@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.AddressPrefixItemArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.AddressPrefixType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Address prefix item.
 * @property addressPrefix Address prefix.
 * @property addressPrefixType Address prefix type.
 */
public data class AddressPrefixItemArgs(
    public val addressPrefix: Output<String>? = null,
    public val addressPrefixType: Output<Either<String, AddressPrefixType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.AddressPrefixItemArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.AddressPrefixItemArgs =
        com.pulumi.azurenative.network.inputs.AddressPrefixItemArgs.builder()
            .addressPrefix(addressPrefix?.applyValue({ args0 -> args0 }))
            .addressPrefixType(
                addressPrefixType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            ).build()
}

/**
 * Builder for [AddressPrefixItemArgs].
 */
@PulumiTagMarker
public class AddressPrefixItemArgsBuilder internal constructor() {
    private var addressPrefix: Output<String>? = null

    private var addressPrefixType: Output<Either<String, AddressPrefixType>>? = null

    /**
     * @param value Address prefix.
     */
    @JvmName("bqkqatojpjjkyjuu")
    public suspend fun addressPrefix(`value`: Output<String>) {
        this.addressPrefix = value
    }

    /**
     * @param value Address prefix type.
     */
    @JvmName("avvrrdkiqrfaovuc")
    public suspend fun addressPrefixType(`value`: Output<Either<String, AddressPrefixType>>) {
        this.addressPrefixType = value
    }

    /**
     * @param value Address prefix.
     */
    @JvmName("ndvvmwwfxdrsikbf")
    public suspend fun addressPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressPrefix = mapped
    }

    /**
     * @param value Address prefix type.
     */
    @JvmName("uhymvrbcfquwiipe")
    public suspend fun addressPrefixType(`value`: Either<String, AddressPrefixType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressPrefixType = mapped
    }

    /**
     * @param value Address prefix type.
     */
    @JvmName("lmjmyqhinjkawgio")
    public fun addressPrefixType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AddressPrefixType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.addressPrefixType = mapped
    }

    /**
     * @param value Address prefix type.
     */
    @JvmName("hahnkgjsfrmupsqg")
    public fun addressPrefixType(`value`: AddressPrefixType) {
        val toBeMapped = Either.ofRight<String, AddressPrefixType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.addressPrefixType = mapped
    }

    internal fun build(): AddressPrefixItemArgs = AddressPrefixItemArgs(
        addressPrefix = addressPrefix,
        addressPrefixType = addressPrefixType,
    )
}
