@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ApplicationGatewayBackendAddressArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Backend address of an application gateway.
 * @property fqdn Fully qualified domain name (FQDN).
 * @property ipAddress IP address.
 */
public data class ApplicationGatewayBackendAddressArgs(
    public val fqdn: Output<String>? = null,
    public val ipAddress: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.ApplicationGatewayBackendAddressArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.ApplicationGatewayBackendAddressArgs =
        com.pulumi.azurenative.network.inputs.ApplicationGatewayBackendAddressArgs.builder()
            .fqdn(fqdn?.applyValue({ args0 -> args0 }))
            .ipAddress(ipAddress?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationGatewayBackendAddressArgs].
 */
@PulumiTagMarker
public class ApplicationGatewayBackendAddressArgsBuilder internal constructor() {
    private var fqdn: Output<String>? = null

    private var ipAddress: Output<String>? = null

    /**
     * @param value Fully qualified domain name (FQDN).
     */
    @JvmName("egsureqajglpqdgx")
    public suspend fun fqdn(`value`: Output<String>) {
        this.fqdn = value
    }

    /**
     * @param value IP address.
     */
    @JvmName("qlpirbqmpuanadsi")
    public suspend fun ipAddress(`value`: Output<String>) {
        this.ipAddress = value
    }

    /**
     * @param value Fully qualified domain name (FQDN).
     */
    @JvmName("onqonpsxossypmio")
    public suspend fun fqdn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fqdn = mapped
    }

    /**
     * @param value IP address.
     */
    @JvmName("qkmsbalwswnxjejq")
    public suspend fun ipAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipAddress = mapped
    }

    internal fun build(): ApplicationGatewayBackendAddressArgs = ApplicationGatewayBackendAddressArgs(
        fqdn = fqdn,
        ipAddress = ipAddress,
    )
}
