@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ApplicationGatewayBackendAddressPoolArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Backend Address Pool of an application gateway.
 * @property backendAddresses Backend addresses.
 * @property id Resource ID.
 * @property name Name of the backend address pool that is unique within an Application Gateway.
 */
public data class ApplicationGatewayBackendAddressPoolArgs(
    public val backendAddresses: Output<List<ApplicationGatewayBackendAddressArgs>>? = null,
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.ApplicationGatewayBackendAddressPoolArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.ApplicationGatewayBackendAddressPoolArgs =
        com.pulumi.azurenative.network.inputs.ApplicationGatewayBackendAddressPoolArgs.builder()
            .backendAddresses(
                backendAddresses?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationGatewayBackendAddressPoolArgs].
 */
@PulumiTagMarker
public class ApplicationGatewayBackendAddressPoolArgsBuilder internal constructor() {
    private var backendAddresses: Output<List<ApplicationGatewayBackendAddressArgs>>? = null

    private var id: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value Backend addresses.
     */
    @JvmName("nisvbpwatedjgbpi")
    public suspend fun backendAddresses(`value`: Output<List<ApplicationGatewayBackendAddressArgs>>) {
        this.backendAddresses = value
    }

    @JvmName("jbljurlugviyihyt")
    public suspend fun backendAddresses(vararg values: Output<ApplicationGatewayBackendAddressArgs>) {
        this.backendAddresses = Output.all(values.asList())
    }

    /**
     * @param values Backend addresses.
     */
    @JvmName("yqbhfwwybxavqpqy")
    public suspend fun backendAddresses(values: List<Output<ApplicationGatewayBackendAddressArgs>>) {
        this.backendAddresses = Output.all(values)
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("vlginhksgtwdrmua")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Name of the backend address pool that is unique within an Application Gateway.
     */
    @JvmName("teghtcsxwsukpcnh")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Backend addresses.
     */
    @JvmName("nicapmvkegcaryxx")
    public suspend fun backendAddresses(`value`: List<ApplicationGatewayBackendAddressArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backendAddresses = mapped
    }

    /**
     * @param argument Backend addresses.
     */
    @JvmName("nvsemmaogqoshkno")
    public suspend
    fun backendAddresses(argument: List<suspend ApplicationGatewayBackendAddressArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewayBackendAddressArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.backendAddresses = mapped
    }

    /**
     * @param argument Backend addresses.
     */
    @JvmName("lttbwhmifnvpdxtv")
    public suspend fun backendAddresses(
        vararg
        argument: suspend ApplicationGatewayBackendAddressArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewayBackendAddressArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.backendAddresses = mapped
    }

    /**
     * @param argument Backend addresses.
     */
    @JvmName("grevjcphmsfmtswq")
    public suspend
    fun backendAddresses(argument: suspend ApplicationGatewayBackendAddressArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ApplicationGatewayBackendAddressArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.backendAddresses = mapped
    }

    /**
     * @param values Backend addresses.
     */
    @JvmName("xwukxkwrhayqurmd")
    public suspend fun backendAddresses(vararg values: ApplicationGatewayBackendAddressArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backendAddresses = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("dwrebsfbvpajjfwe")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Name of the backend address pool that is unique within an Application Gateway.
     */
    @JvmName("lytojccdwfjnuuym")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): ApplicationGatewayBackendAddressPoolArgs =
        ApplicationGatewayBackendAddressPoolArgs(
            backendAddresses = backendAddresses,
            id = id,
            name = name,
        )
}
