@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ApplicationGatewayBackendHttpSettingsArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.ApplicationGatewayCookieBasedAffinity
import com.pulumi.azurenative.network.kotlin.enums.ApplicationGatewayProtocol
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Backend address pool settings of an application gateway.
 * @property affinityCookieName Cookie name to use for the affinity cookie.
 * @property authenticationCertificates Array of references to application gateway authentication certificates.
 * @property connectionDraining Connection draining of the backend http settings resource.
 * @property cookieBasedAffinity Cookie based affinity.
 * @property hostName Host header to be sent to the backend servers.
 * @property id Resource ID.
 * @property name Name of the backend http settings that is unique within an Application Gateway.
 * @property path Path which should be used as a prefix for all HTTP requests. Null means no path will be prefixed. Default value is null.
 * @property pickHostNameFromBackendAddress Whether to pick host header should be picked from the host name of the backend server. Default value is false.
 * @property port The destination port on the backend.
 * @property probe Probe resource of an application gateway.
 * @property probeEnabled Whether the probe is enabled. Default value is false.
 * @property protocol The protocol used to communicate with the backend.
 * @property requestTimeout Request timeout in seconds. Application Gateway will fail the request if response is not received within RequestTimeout. Acceptable values are from 1 second to 86400 seconds.
 * @property trustedRootCertificates Array of references to application gateway trusted root certificates.
 */
public data class ApplicationGatewayBackendHttpSettingsArgs(
    public val affinityCookieName: Output<String>? = null,
    public val authenticationCertificates: Output<List<SubResourceArgs>>? = null,
    public val connectionDraining: Output<ApplicationGatewayConnectionDrainingArgs>? = null,
    public val cookieBasedAffinity: Output<Either<String, ApplicationGatewayCookieBasedAffinity>>? =
        null,
    public val hostName: Output<String>? = null,
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
    public val path: Output<String>? = null,
    public val pickHostNameFromBackendAddress: Output<Boolean>? = null,
    public val port: Output<Int>? = null,
    public val probe: Output<SubResourceArgs>? = null,
    public val probeEnabled: Output<Boolean>? = null,
    public val protocol: Output<Either<String, ApplicationGatewayProtocol>>? = null,
    public val requestTimeout: Output<Int>? = null,
    public val trustedRootCertificates: Output<List<SubResourceArgs>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.ApplicationGatewayBackendHttpSettingsArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.ApplicationGatewayBackendHttpSettingsArgs =
        com.pulumi.azurenative.network.inputs.ApplicationGatewayBackendHttpSettingsArgs.builder()
            .affinityCookieName(affinityCookieName?.applyValue({ args0 -> args0 }))
            .authenticationCertificates(
                authenticationCertificates?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .connectionDraining(
                connectionDraining?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .cookieBasedAffinity(
                cookieBasedAffinity?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .hostName(hostName?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .path(path?.applyValue({ args0 -> args0 }))
            .pickHostNameFromBackendAddress(pickHostNameFromBackendAddress?.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 }))
            .probe(probe?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .probeEnabled(probeEnabled?.applyValue({ args0 -> args0 }))
            .protocol(
                protocol?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .requestTimeout(requestTimeout?.applyValue({ args0 -> args0 }))
            .trustedRootCertificates(
                trustedRootCertificates?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [ApplicationGatewayBackendHttpSettingsArgs].
 */
@PulumiTagMarker
public class ApplicationGatewayBackendHttpSettingsArgsBuilder internal constructor() {
    private var affinityCookieName: Output<String>? = null

    private var authenticationCertificates: Output<List<SubResourceArgs>>? = null

    private var connectionDraining: Output<ApplicationGatewayConnectionDrainingArgs>? = null

    private var cookieBasedAffinity: Output<Either<String, ApplicationGatewayCookieBasedAffinity>>? =
        null

    private var hostName: Output<String>? = null

    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var path: Output<String>? = null

    private var pickHostNameFromBackendAddress: Output<Boolean>? = null

    private var port: Output<Int>? = null

    private var probe: Output<SubResourceArgs>? = null

    private var probeEnabled: Output<Boolean>? = null

    private var protocol: Output<Either<String, ApplicationGatewayProtocol>>? = null

    private var requestTimeout: Output<Int>? = null

    private var trustedRootCertificates: Output<List<SubResourceArgs>>? = null

    /**
     * @param value Cookie name to use for the affinity cookie.
     */
    @JvmName("yqauhfiyjlsjiuft")
    public suspend fun affinityCookieName(`value`: Output<String>) {
        this.affinityCookieName = value
    }

    /**
     * @param value Array of references to application gateway authentication certificates.
     */
    @JvmName("hrdaxmqompkeepld")
    public suspend fun authenticationCertificates(`value`: Output<List<SubResourceArgs>>) {
        this.authenticationCertificates = value
    }

    @JvmName("acaqnwaewkjkrdlk")
    public suspend fun authenticationCertificates(vararg values: Output<SubResourceArgs>) {
        this.authenticationCertificates = Output.all(values.asList())
    }

    /**
     * @param values Array of references to application gateway authentication certificates.
     */
    @JvmName("olfpbcpklbhwhusx")
    public suspend fun authenticationCertificates(values: List<Output<SubResourceArgs>>) {
        this.authenticationCertificates = Output.all(values)
    }

    /**
     * @param value Connection draining of the backend http settings resource.
     */
    @JvmName("pbibtteyupegkvhe")
    public suspend fun connectionDraining(`value`: Output<ApplicationGatewayConnectionDrainingArgs>) {
        this.connectionDraining = value
    }

    /**
     * @param value Cookie based affinity.
     */
    @JvmName("dcpxsdcehauhwlhp")
    public suspend
    fun cookieBasedAffinity(`value`: Output<Either<String, ApplicationGatewayCookieBasedAffinity>>) {
        this.cookieBasedAffinity = value
    }

    /**
     * @param value Host header to be sent to the backend servers.
     */
    @JvmName("kasghdhsypeqwufl")
    public suspend fun hostName(`value`: Output<String>) {
        this.hostName = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("oxswsijskcyavsje")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Name of the backend http settings that is unique within an Application Gateway.
     */
    @JvmName("olxuwgqttjreqdou")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Path which should be used as a prefix for all HTTP requests. Null means no path will be prefixed. Default value is null.
     */
    @JvmName("mjmfdunaeexkphfh")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value Whether to pick host header should be picked from the host name of the backend server. Default value is false.
     */
    @JvmName("jriijuwxumvjagxh")
    public suspend fun pickHostNameFromBackendAddress(`value`: Output<Boolean>) {
        this.pickHostNameFromBackendAddress = value
    }

    /**
     * @param value The destination port on the backend.
     */
    @JvmName("nmstebyhfmdjxfpp")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value Probe resource of an application gateway.
     */
    @JvmName("hhfgklbrdsjfsoth")
    public suspend fun probe(`value`: Output<SubResourceArgs>) {
        this.probe = value
    }

    /**
     * @param value Whether the probe is enabled. Default value is false.
     */
    @JvmName("lodspxenitlqrycc")
    public suspend fun probeEnabled(`value`: Output<Boolean>) {
        this.probeEnabled = value
    }

    /**
     * @param value The protocol used to communicate with the backend.
     */
    @JvmName("pslvkpmtxrxqbucr")
    public suspend fun protocol(`value`: Output<Either<String, ApplicationGatewayProtocol>>) {
        this.protocol = value
    }

    /**
     * @param value Request timeout in seconds. Application Gateway will fail the request if response is not received within RequestTimeout. Acceptable values are from 1 second to 86400 seconds.
     */
    @JvmName("wwdchvbqqnxodrxv")
    public suspend fun requestTimeout(`value`: Output<Int>) {
        this.requestTimeout = value
    }

    /**
     * @param value Array of references to application gateway trusted root certificates.
     */
    @JvmName("rohyubnjyvovsjdx")
    public suspend fun trustedRootCertificates(`value`: Output<List<SubResourceArgs>>) {
        this.trustedRootCertificates = value
    }

    @JvmName("ustuojcfkiucokow")
    public suspend fun trustedRootCertificates(vararg values: Output<SubResourceArgs>) {
        this.trustedRootCertificates = Output.all(values.asList())
    }

    /**
     * @param values Array of references to application gateway trusted root certificates.
     */
    @JvmName("tnjlcctwdlwumcoh")
    public suspend fun trustedRootCertificates(values: List<Output<SubResourceArgs>>) {
        this.trustedRootCertificates = Output.all(values)
    }

    /**
     * @param value Cookie name to use for the affinity cookie.
     */
    @JvmName("inlvegtgogblssfv")
    public suspend fun affinityCookieName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.affinityCookieName = mapped
    }

    /**
     * @param value Array of references to application gateway authentication certificates.
     */
    @JvmName("xqrnohnymosyrhdg")
    public suspend fun authenticationCertificates(`value`: List<SubResourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationCertificates = mapped
    }

    /**
     * @param argument Array of references to application gateway authentication certificates.
     */
    @JvmName("gjclgnfbfoxpdgel")
    public suspend
    fun authenticationCertificates(argument: List<suspend SubResourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.authenticationCertificates = mapped
    }

    /**
     * @param argument Array of references to application gateway authentication certificates.
     */
    @JvmName("nqtjmjgldiseexos")
    public suspend fun authenticationCertificates(
        vararg
        argument: suspend SubResourceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.authenticationCertificates = mapped
    }

    /**
     * @param argument Array of references to application gateway authentication certificates.
     */
    @JvmName("ehixvbcfftbncriw")
    public suspend
    fun authenticationCertificates(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SubResourceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.authenticationCertificates = mapped
    }

    /**
     * @param values Array of references to application gateway authentication certificates.
     */
    @JvmName("karxknvglyufwwsl")
    public suspend fun authenticationCertificates(vararg values: SubResourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationCertificates = mapped
    }

    /**
     * @param value Connection draining of the backend http settings resource.
     */
    @JvmName("wtmpimuixfwmtlrg")
    public suspend fun connectionDraining(`value`: ApplicationGatewayConnectionDrainingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionDraining = mapped
    }

    /**
     * @param argument Connection draining of the backend http settings resource.
     */
    @JvmName("uoviyuqlmapjsvut")
    public suspend
    fun connectionDraining(argument: suspend ApplicationGatewayConnectionDrainingArgsBuilder.() -> Unit) {
        val toBeMapped = ApplicationGatewayConnectionDrainingArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.connectionDraining = mapped
    }

    /**
     * @param value Cookie based affinity.
     */
    @JvmName("kjqimfvyfbxrneof")
    public suspend
    fun cookieBasedAffinity(`value`: Either<String, ApplicationGatewayCookieBasedAffinity>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cookieBasedAffinity = mapped
    }

    /**
     * @param value Cookie based affinity.
     */
    @JvmName("lrvyugrawiiuirvu")
    public fun cookieBasedAffinity(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ApplicationGatewayCookieBasedAffinity>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cookieBasedAffinity = mapped
    }

    /**
     * @param value Cookie based affinity.
     */
    @JvmName("qdriduifpmqiblfc")
    public fun cookieBasedAffinity(`value`: ApplicationGatewayCookieBasedAffinity) {
        val toBeMapped = Either.ofRight<String, ApplicationGatewayCookieBasedAffinity>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cookieBasedAffinity = mapped
    }

    /**
     * @param value Host header to be sent to the backend servers.
     */
    @JvmName("wmrcjqbpfemahqnm")
    public suspend fun hostName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostName = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("xendtyopghhtxeuc")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Name of the backend http settings that is unique within an Application Gateway.
     */
    @JvmName("pamyqarrcbnhlbob")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Path which should be used as a prefix for all HTTP requests. Null means no path will be prefixed. Default value is null.
     */
    @JvmName("ramaxtpbrutdehqb")
    public suspend fun path(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    /**
     * @param value Whether to pick host header should be picked from the host name of the backend server. Default value is false.
     */
    @JvmName("beftjqcgxrnlvihj")
    public suspend fun pickHostNameFromBackendAddress(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pickHostNameFromBackendAddress = mapped
    }

    /**
     * @param value The destination port on the backend.
     */
    @JvmName("frxovdmutfndxbmn")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value Probe resource of an application gateway.
     */
    @JvmName("pxknqetnvjcbqwtj")
    public suspend fun probe(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.probe = mapped
    }

    /**
     * @param argument Probe resource of an application gateway.
     */
    @JvmName("kcdvctybewenbnjh")
    public suspend fun probe(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.probe = mapped
    }

    /**
     * @param value Whether the probe is enabled. Default value is false.
     */
    @JvmName("jqfnxnuyxgbwhacp")
    public suspend fun probeEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.probeEnabled = mapped
    }

    /**
     * @param value The protocol used to communicate with the backend.
     */
    @JvmName("gdoufrwbknvilmpm")
    public suspend fun protocol(`value`: Either<String, ApplicationGatewayProtocol>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value The protocol used to communicate with the backend.
     */
    @JvmName("wogrrwxdrsfmfwhm")
    public fun protocol(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ApplicationGatewayProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value The protocol used to communicate with the backend.
     */
    @JvmName("bgwikbrgvettcmeb")
    public fun protocol(`value`: ApplicationGatewayProtocol) {
        val toBeMapped = Either.ofRight<String, ApplicationGatewayProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Request timeout in seconds. Application Gateway will fail the request if response is not received within RequestTimeout. Acceptable values are from 1 second to 86400 seconds.
     */
    @JvmName("nudfcdjwnngibhqx")
    public suspend fun requestTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestTimeout = mapped
    }

    /**
     * @param value Array of references to application gateway trusted root certificates.
     */
    @JvmName("cgsnmjaepleytmsw")
    public suspend fun trustedRootCertificates(`value`: List<SubResourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trustedRootCertificates = mapped
    }

    /**
     * @param argument Array of references to application gateway trusted root certificates.
     */
    @JvmName("scjelxdxkmemwhvi")
    public suspend
    fun trustedRootCertificates(argument: List<suspend SubResourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.trustedRootCertificates = mapped
    }

    /**
     * @param argument Array of references to application gateway trusted root certificates.
     */
    @JvmName("jrobspmpnjitrkst")
    public suspend fun trustedRootCertificates(
        vararg
        argument: suspend SubResourceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.trustedRootCertificates = mapped
    }

    /**
     * @param argument Array of references to application gateway trusted root certificates.
     */
    @JvmName("omfqqknixbpaasyf")
    public suspend fun trustedRootCertificates(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SubResourceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.trustedRootCertificates = mapped
    }

    /**
     * @param values Array of references to application gateway trusted root certificates.
     */
    @JvmName("snentuaksabloaau")
    public suspend fun trustedRootCertificates(vararg values: SubResourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trustedRootCertificates = mapped
    }

    internal fun build(): ApplicationGatewayBackendHttpSettingsArgs =
        ApplicationGatewayBackendHttpSettingsArgs(
            affinityCookieName = affinityCookieName,
            authenticationCertificates = authenticationCertificates,
            connectionDraining = connectionDraining,
            cookieBasedAffinity = cookieBasedAffinity,
            hostName = hostName,
            id = id,
            name = name,
            path = path,
            pickHostNameFromBackendAddress = pickHostNameFromBackendAddress,
            port = port,
            probe = probe,
            probeEnabled = probeEnabled,
            protocol = protocol,
            requestTimeout = requestTimeout,
            trustedRootCertificates = trustedRootCertificates,
        )
}
