@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ApplicationGatewayBackendSettingsArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.ApplicationGatewayProtocol
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Backend address pool settings of an application gateway.
 * @property hostName Server name indication to be sent to the backend servers for Tls protocol.
 * @property id Resource ID.
 * @property name Name of the backend settings that is unique within an Application Gateway.
 * @property pickHostNameFromBackendAddress Whether to pick server name indication from the host name of the backend server for Tls protocol. Default value is false.
 * @property port The destination port on the backend.
 * @property probe Probe resource of an application gateway.
 * @property protocol The protocol used to communicate with the backend.
 * @property timeout Connection timeout in seconds. Application Gateway will fail the request if response is not received within ConnectionTimeout. Acceptable values are from 1 second to 86400 seconds.
 * @property trustedRootCertificates Array of references to application gateway trusted root certificates.
 */
public data class ApplicationGatewayBackendSettingsArgs(
    public val hostName: Output<String>? = null,
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
    public val pickHostNameFromBackendAddress: Output<Boolean>? = null,
    public val port: Output<Int>? = null,
    public val probe: Output<SubResourceArgs>? = null,
    public val protocol: Output<Either<String, ApplicationGatewayProtocol>>? = null,
    public val timeout: Output<Int>? = null,
    public val trustedRootCertificates: Output<List<SubResourceArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.ApplicationGatewayBackendSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.ApplicationGatewayBackendSettingsArgs =
        com.pulumi.azurenative.network.inputs.ApplicationGatewayBackendSettingsArgs.builder()
            .hostName(hostName?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .pickHostNameFromBackendAddress(pickHostNameFromBackendAddress?.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 }))
            .probe(probe?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .protocol(
                protocol?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .timeout(timeout?.applyValue({ args0 -> args0 }))
            .trustedRootCertificates(
                trustedRootCertificates?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [ApplicationGatewayBackendSettingsArgs].
 */
@PulumiTagMarker
public class ApplicationGatewayBackendSettingsArgsBuilder internal constructor() {
    private var hostName: Output<String>? = null

    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var pickHostNameFromBackendAddress: Output<Boolean>? = null

    private var port: Output<Int>? = null

    private var probe: Output<SubResourceArgs>? = null

    private var protocol: Output<Either<String, ApplicationGatewayProtocol>>? = null

    private var timeout: Output<Int>? = null

    private var trustedRootCertificates: Output<List<SubResourceArgs>>? = null

    /**
     * @param value Server name indication to be sent to the backend servers for Tls protocol.
     */
    @JvmName("mweqaflfyrgxwvnj")
    public suspend fun hostName(`value`: Output<String>) {
        this.hostName = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("lnqxlddbtjogbnws")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Name of the backend settings that is unique within an Application Gateway.
     */
    @JvmName("watsvfadfhtejpkp")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Whether to pick server name indication from the host name of the backend server for Tls protocol. Default value is false.
     */
    @JvmName("apxxpecdwojbteso")
    public suspend fun pickHostNameFromBackendAddress(`value`: Output<Boolean>) {
        this.pickHostNameFromBackendAddress = value
    }

    /**
     * @param value The destination port on the backend.
     */
    @JvmName("pyeulqgynvyevcyj")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value Probe resource of an application gateway.
     */
    @JvmName("cdsvgmlgqgtdtums")
    public suspend fun probe(`value`: Output<SubResourceArgs>) {
        this.probe = value
    }

    /**
     * @param value The protocol used to communicate with the backend.
     */
    @JvmName("svymrjtbeuxwpmcp")
    public suspend fun protocol(`value`: Output<Either<String, ApplicationGatewayProtocol>>) {
        this.protocol = value
    }

    /**
     * @param value Connection timeout in seconds. Application Gateway will fail the request if response is not received within ConnectionTimeout. Acceptable values are from 1 second to 86400 seconds.
     */
    @JvmName("rqcrfyvigaxrgirv")
    public suspend fun timeout(`value`: Output<Int>) {
        this.timeout = value
    }

    /**
     * @param value Array of references to application gateway trusted root certificates.
     */
    @JvmName("uioldnwsukujudea")
    public suspend fun trustedRootCertificates(`value`: Output<List<SubResourceArgs>>) {
        this.trustedRootCertificates = value
    }

    @JvmName("xfksqtrbnvciymnv")
    public suspend fun trustedRootCertificates(vararg values: Output<SubResourceArgs>) {
        this.trustedRootCertificates = Output.all(values.asList())
    }

    /**
     * @param values Array of references to application gateway trusted root certificates.
     */
    @JvmName("qwenlnxgintipdfc")
    public suspend fun trustedRootCertificates(values: List<Output<SubResourceArgs>>) {
        this.trustedRootCertificates = Output.all(values)
    }

    /**
     * @param value Server name indication to be sent to the backend servers for Tls protocol.
     */
    @JvmName("ocyhigqymcgelyck")
    public suspend fun hostName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostName = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("ceuwgnrwwgnfibvm")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Name of the backend settings that is unique within an Application Gateway.
     */
    @JvmName("tagpaqvfjgycumrr")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Whether to pick server name indication from the host name of the backend server for Tls protocol. Default value is false.
     */
    @JvmName("odasjmvnhhfdwnli")
    public suspend fun pickHostNameFromBackendAddress(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pickHostNameFromBackendAddress = mapped
    }

    /**
     * @param value The destination port on the backend.
     */
    @JvmName("otgulunamavprxwo")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value Probe resource of an application gateway.
     */
    @JvmName("cmmrnfbitjofvphm")
    public suspend fun probe(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.probe = mapped
    }

    /**
     * @param argument Probe resource of an application gateway.
     */
    @JvmName("ahykifgxhpqjbkyv")
    public suspend fun probe(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.probe = mapped
    }

    /**
     * @param value The protocol used to communicate with the backend.
     */
    @JvmName("qegkddpuuhulkbry")
    public suspend fun protocol(`value`: Either<String, ApplicationGatewayProtocol>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value The protocol used to communicate with the backend.
     */
    @JvmName("nnfyldkmntoilolq")
    public fun protocol(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ApplicationGatewayProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value The protocol used to communicate with the backend.
     */
    @JvmName("aolmpgrgyugnqtnx")
    public fun protocol(`value`: ApplicationGatewayProtocol) {
        val toBeMapped = Either.ofRight<String, ApplicationGatewayProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Connection timeout in seconds. Application Gateway will fail the request if response is not received within ConnectionTimeout. Acceptable values are from 1 second to 86400 seconds.
     */
    @JvmName("qpuoktpqluyluabb")
    public suspend fun timeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeout = mapped
    }

    /**
     * @param value Array of references to application gateway trusted root certificates.
     */
    @JvmName("vkoglqywoiwvsdcy")
    public suspend fun trustedRootCertificates(`value`: List<SubResourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trustedRootCertificates = mapped
    }

    /**
     * @param argument Array of references to application gateway trusted root certificates.
     */
    @JvmName("ujflltfhjrfahjpb")
    public suspend
    fun trustedRootCertificates(argument: List<suspend SubResourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.trustedRootCertificates = mapped
    }

    /**
     * @param argument Array of references to application gateway trusted root certificates.
     */
    @JvmName("phvibrnygxcmywqr")
    public suspend fun trustedRootCertificates(
        vararg
        argument: suspend SubResourceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.trustedRootCertificates = mapped
    }

    /**
     * @param argument Array of references to application gateway trusted root certificates.
     */
    @JvmName("fjcnfcrxfgafujsy")
    public suspend fun trustedRootCertificates(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SubResourceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.trustedRootCertificates = mapped
    }

    /**
     * @param values Array of references to application gateway trusted root certificates.
     */
    @JvmName("gfnwtgohyxkjegoh")
    public suspend fun trustedRootCertificates(vararg values: SubResourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trustedRootCertificates = mapped
    }

    internal fun build(): ApplicationGatewayBackendSettingsArgs =
        ApplicationGatewayBackendSettingsArgs(
            hostName = hostName,
            id = id,
            name = name,
            pickHostNameFromBackendAddress = pickHostNameFromBackendAddress,
            port = port,
            probe = probe,
            protocol = protocol,
            timeout = timeout,
            trustedRootCertificates = trustedRootCertificates,
        )
}
