@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ApplicationGatewayGlobalConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Application Gateway global configuration.
 * @property enableRequestBuffering Enable request buffering.
 * @property enableResponseBuffering Enable response buffering.
 */
public data class ApplicationGatewayGlobalConfigurationArgs(
    public val enableRequestBuffering: Output<Boolean>? = null,
    public val enableResponseBuffering: Output<Boolean>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.ApplicationGatewayGlobalConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.ApplicationGatewayGlobalConfigurationArgs =
        com.pulumi.azurenative.network.inputs.ApplicationGatewayGlobalConfigurationArgs.builder()
            .enableRequestBuffering(enableRequestBuffering?.applyValue({ args0 -> args0 }))
            .enableResponseBuffering(enableResponseBuffering?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationGatewayGlobalConfigurationArgs].
 */
@PulumiTagMarker
public class ApplicationGatewayGlobalConfigurationArgsBuilder internal constructor() {
    private var enableRequestBuffering: Output<Boolean>? = null

    private var enableResponseBuffering: Output<Boolean>? = null

    /**
     * @param value Enable request buffering.
     */
    @JvmName("whhqousiupvljajq")
    public suspend fun enableRequestBuffering(`value`: Output<Boolean>) {
        this.enableRequestBuffering = value
    }

    /**
     * @param value Enable response buffering.
     */
    @JvmName("lmksjgicmvyyldms")
    public suspend fun enableResponseBuffering(`value`: Output<Boolean>) {
        this.enableResponseBuffering = value
    }

    /**
     * @param value Enable request buffering.
     */
    @JvmName("tdssvyabsytttenb")
    public suspend fun enableRequestBuffering(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableRequestBuffering = mapped
    }

    /**
     * @param value Enable response buffering.
     */
    @JvmName("nhygygbullialvej")
    public suspend fun enableResponseBuffering(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableResponseBuffering = mapped
    }

    internal fun build(): ApplicationGatewayGlobalConfigurationArgs =
        ApplicationGatewayGlobalConfigurationArgs(
            enableRequestBuffering = enableRequestBuffering,
            enableResponseBuffering = enableResponseBuffering,
        )
}
