@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ApplicationGatewayHeaderConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Header configuration of the Actions set in Application Gateway.
 * @property headerName Header name of the header configuration.
 * @property headerValue Header value of the header configuration.
 */
public data class ApplicationGatewayHeaderConfigurationArgs(
    public val headerName: Output<String>? = null,
    public val headerValue: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.ApplicationGatewayHeaderConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.ApplicationGatewayHeaderConfigurationArgs =
        com.pulumi.azurenative.network.inputs.ApplicationGatewayHeaderConfigurationArgs.builder()
            .headerName(headerName?.applyValue({ args0 -> args0 }))
            .headerValue(headerValue?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationGatewayHeaderConfigurationArgs].
 */
@PulumiTagMarker
public class ApplicationGatewayHeaderConfigurationArgsBuilder internal constructor() {
    private var headerName: Output<String>? = null

    private var headerValue: Output<String>? = null

    /**
     * @param value Header name of the header configuration.
     */
    @JvmName("wpxndcsgnndjppws")
    public suspend fun headerName(`value`: Output<String>) {
        this.headerName = value
    }

    /**
     * @param value Header value of the header configuration.
     */
    @JvmName("exlfewvjklafyxuq")
    public suspend fun headerValue(`value`: Output<String>) {
        this.headerValue = value
    }

    /**
     * @param value Header name of the header configuration.
     */
    @JvmName("exvutywpbinnfyjw")
    public suspend fun headerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.headerName = mapped
    }

    /**
     * @param value Header value of the header configuration.
     */
    @JvmName("ywrkasoyylllmshg")
    public suspend fun headerValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.headerValue = mapped
    }

    internal fun build(): ApplicationGatewayHeaderConfigurationArgs =
        ApplicationGatewayHeaderConfigurationArgs(
            headerName = headerName,
            headerValue = headerValue,
        )
}
