@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ApplicationGatewayHttpListenerArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.ApplicationGatewayProtocol
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Http listener of an application gateway.
 * @property customErrorConfigurations Custom error configurations of the HTTP listener.
 * @property firewallPolicy Reference to the FirewallPolicy resource.
 * @property frontendIPConfiguration Frontend IP configuration resource of an application gateway.
 * @property frontendPort Frontend port resource of an application gateway.
 * @property hostName Host name of HTTP listener.
 * @property hostNames List of Host names for HTTP Listener that allows special wildcard characters as well.
 * @property id Resource ID.
 * @property name Name of the HTTP listener that is unique within an Application Gateway.
 * @property protocol Protocol of the HTTP listener.
 * @property requireServerNameIndication Applicable only if protocol is https. Enables SNI for multi-hosting.
 * @property sslCertificate SSL certificate resource of an application gateway.
 * @property sslProfile SSL profile resource of the application gateway.
 */
public data class ApplicationGatewayHttpListenerArgs(
    public val customErrorConfigurations: Output<List<ApplicationGatewayCustomErrorArgs>>? = null,
    public val firewallPolicy: Output<SubResourceArgs>? = null,
    public val frontendIPConfiguration: Output<SubResourceArgs>? = null,
    public val frontendPort: Output<SubResourceArgs>? = null,
    public val hostName: Output<String>? = null,
    public val hostNames: Output<List<String>>? = null,
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
    public val protocol: Output<Either<String, ApplicationGatewayProtocol>>? = null,
    public val requireServerNameIndication: Output<Boolean>? = null,
    public val sslCertificate: Output<SubResourceArgs>? = null,
    public val sslProfile: Output<SubResourceArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.ApplicationGatewayHttpListenerArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.ApplicationGatewayHttpListenerArgs =
        com.pulumi.azurenative.network.inputs.ApplicationGatewayHttpListenerArgs.builder()
            .customErrorConfigurations(
                customErrorConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .firewallPolicy(firewallPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .frontendIPConfiguration(
                frontendIPConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .frontendPort(frontendPort?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .hostName(hostName?.applyValue({ args0 -> args0 }))
            .hostNames(hostNames?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .protocol(
                protocol?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .requireServerNameIndication(requireServerNameIndication?.applyValue({ args0 -> args0 }))
            .sslCertificate(sslCertificate?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sslProfile(sslProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ApplicationGatewayHttpListenerArgs].
 */
@PulumiTagMarker
public class ApplicationGatewayHttpListenerArgsBuilder internal constructor() {
    private var customErrorConfigurations: Output<List<ApplicationGatewayCustomErrorArgs>>? = null

    private var firewallPolicy: Output<SubResourceArgs>? = null

    private var frontendIPConfiguration: Output<SubResourceArgs>? = null

    private var frontendPort: Output<SubResourceArgs>? = null

    private var hostName: Output<String>? = null

    private var hostNames: Output<List<String>>? = null

    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var protocol: Output<Either<String, ApplicationGatewayProtocol>>? = null

    private var requireServerNameIndication: Output<Boolean>? = null

    private var sslCertificate: Output<SubResourceArgs>? = null

    private var sslProfile: Output<SubResourceArgs>? = null

    /**
     * @param value Custom error configurations of the HTTP listener.
     */
    @JvmName("ocdeyecbevqbmtwb")
    public suspend
    fun customErrorConfigurations(`value`: Output<List<ApplicationGatewayCustomErrorArgs>>) {
        this.customErrorConfigurations = value
    }

    @JvmName("gtsvwcvlndimmgdk")
    public suspend fun customErrorConfigurations(
        vararg
        values: Output<ApplicationGatewayCustomErrorArgs>,
    ) {
        this.customErrorConfigurations = Output.all(values.asList())
    }

    /**
     * @param values Custom error configurations of the HTTP listener.
     */
    @JvmName("ptdcfxgemqtynbom")
    public suspend
    fun customErrorConfigurations(values: List<Output<ApplicationGatewayCustomErrorArgs>>) {
        this.customErrorConfigurations = Output.all(values)
    }

    /**
     * @param value Reference to the FirewallPolicy resource.
     */
    @JvmName("adursawjuxrrpvec")
    public suspend fun firewallPolicy(`value`: Output<SubResourceArgs>) {
        this.firewallPolicy = value
    }

    /**
     * @param value Frontend IP configuration resource of an application gateway.
     */
    @JvmName("iuqswkgrgqtbmkah")
    public suspend fun frontendIPConfiguration(`value`: Output<SubResourceArgs>) {
        this.frontendIPConfiguration = value
    }

    /**
     * @param value Frontend port resource of an application gateway.
     */
    @JvmName("agactcqdtxammoyj")
    public suspend fun frontendPort(`value`: Output<SubResourceArgs>) {
        this.frontendPort = value
    }

    /**
     * @param value Host name of HTTP listener.
     */
    @JvmName("iwvyjqujsfosejhp")
    public suspend fun hostName(`value`: Output<String>) {
        this.hostName = value
    }

    /**
     * @param value List of Host names for HTTP Listener that allows special wildcard characters as well.
     */
    @JvmName("yxisusiyvlyychlc")
    public suspend fun hostNames(`value`: Output<List<String>>) {
        this.hostNames = value
    }

    @JvmName("fejjcfkwwdxydfre")
    public suspend fun hostNames(vararg values: Output<String>) {
        this.hostNames = Output.all(values.asList())
    }

    /**
     * @param values List of Host names for HTTP Listener that allows special wildcard characters as well.
     */
    @JvmName("lhxnjgftxyogtplr")
    public suspend fun hostNames(values: List<Output<String>>) {
        this.hostNames = Output.all(values)
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("tcphernwvnueaawo")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Name of the HTTP listener that is unique within an Application Gateway.
     */
    @JvmName("lgnguoewmwmnggkp")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Protocol of the HTTP listener.
     */
    @JvmName("tfahcycvbwjrjann")
    public suspend fun protocol(`value`: Output<Either<String, ApplicationGatewayProtocol>>) {
        this.protocol = value
    }

    /**
     * @param value Applicable only if protocol is https. Enables SNI for multi-hosting.
     */
    @JvmName("qvuyohfkudytdkcr")
    public suspend fun requireServerNameIndication(`value`: Output<Boolean>) {
        this.requireServerNameIndication = value
    }

    /**
     * @param value SSL certificate resource of an application gateway.
     */
    @JvmName("mpcbuqmcfvdvovpy")
    public suspend fun sslCertificate(`value`: Output<SubResourceArgs>) {
        this.sslCertificate = value
    }

    /**
     * @param value SSL profile resource of the application gateway.
     */
    @JvmName("rvyljbmeypcggyej")
    public suspend fun sslProfile(`value`: Output<SubResourceArgs>) {
        this.sslProfile = value
    }

    /**
     * @param value Custom error configurations of the HTTP listener.
     */
    @JvmName("xjipevhgojshixpn")
    public suspend fun customErrorConfigurations(`value`: List<ApplicationGatewayCustomErrorArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customErrorConfigurations = mapped
    }

    /**
     * @param argument Custom error configurations of the HTTP listener.
     */
    @JvmName("qfwyevycryepdgrt")
    public suspend
    fun customErrorConfigurations(argument: List<suspend ApplicationGatewayCustomErrorArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewayCustomErrorArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.customErrorConfigurations = mapped
    }

    /**
     * @param argument Custom error configurations of the HTTP listener.
     */
    @JvmName("bngtfuxjjvpquhji")
    public suspend fun customErrorConfigurations(
        vararg
        argument: suspend ApplicationGatewayCustomErrorArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewayCustomErrorArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.customErrorConfigurations = mapped
    }

    /**
     * @param argument Custom error configurations of the HTTP listener.
     */
    @JvmName("tupqbhkayibqlsag")
    public suspend
    fun customErrorConfigurations(argument: suspend ApplicationGatewayCustomErrorArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ApplicationGatewayCustomErrorArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.customErrorConfigurations = mapped
    }

    /**
     * @param values Custom error configurations of the HTTP listener.
     */
    @JvmName("nbnkhjgkldkfearh")
    public suspend fun customErrorConfigurations(vararg values: ApplicationGatewayCustomErrorArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customErrorConfigurations = mapped
    }

    /**
     * @param value Reference to the FirewallPolicy resource.
     */
    @JvmName("akhnltxqvbcopogb")
    public suspend fun firewallPolicy(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firewallPolicy = mapped
    }

    /**
     * @param argument Reference to the FirewallPolicy resource.
     */
    @JvmName("jvqbvgiucorwdnxd")
    public suspend fun firewallPolicy(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.firewallPolicy = mapped
    }

    /**
     * @param value Frontend IP configuration resource of an application gateway.
     */
    @JvmName("kjsuyhnyiapqlonr")
    public suspend fun frontendIPConfiguration(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.frontendIPConfiguration = mapped
    }

    /**
     * @param argument Frontend IP configuration resource of an application gateway.
     */
    @JvmName("turycigipgxenvam")
    public suspend fun frontendIPConfiguration(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.frontendIPConfiguration = mapped
    }

    /**
     * @param value Frontend port resource of an application gateway.
     */
    @JvmName("lfxfcawyicovomea")
    public suspend fun frontendPort(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.frontendPort = mapped
    }

    /**
     * @param argument Frontend port resource of an application gateway.
     */
    @JvmName("uawhqitexuxorgwe")
    public suspend fun frontendPort(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.frontendPort = mapped
    }

    /**
     * @param value Host name of HTTP listener.
     */
    @JvmName("psnajxtsvtlypwwn")
    public suspend fun hostName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostName = mapped
    }

    /**
     * @param value List of Host names for HTTP Listener that allows special wildcard characters as well.
     */
    @JvmName("pwfgeumppurahovo")
    public suspend fun hostNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostNames = mapped
    }

    /**
     * @param values List of Host names for HTTP Listener that allows special wildcard characters as well.
     */
    @JvmName("pihsirplrsfpbdje")
    public suspend fun hostNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hostNames = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("shjylnscmaxshoxo")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Name of the HTTP listener that is unique within an Application Gateway.
     */
    @JvmName("wynbdcvepjkaecxq")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Protocol of the HTTP listener.
     */
    @JvmName("bodeuhitvlitaswh")
    public suspend fun protocol(`value`: Either<String, ApplicationGatewayProtocol>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Protocol of the HTTP listener.
     */
    @JvmName("cvsnksxicgknvshd")
    public fun protocol(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ApplicationGatewayProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Protocol of the HTTP listener.
     */
    @JvmName("lapbgwhqdcmdmelc")
    public fun protocol(`value`: ApplicationGatewayProtocol) {
        val toBeMapped = Either.ofRight<String, ApplicationGatewayProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Applicable only if protocol is https. Enables SNI for multi-hosting.
     */
    @JvmName("qedeqblfhambtfrx")
    public suspend fun requireServerNameIndication(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requireServerNameIndication = mapped
    }

    /**
     * @param value SSL certificate resource of an application gateway.
     */
    @JvmName("bgidscuiklekawqb")
    public suspend fun sslCertificate(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sslCertificate = mapped
    }

    /**
     * @param argument SSL certificate resource of an application gateway.
     */
    @JvmName("lwxadaqyrelgwspb")
    public suspend fun sslCertificate(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sslCertificate = mapped
    }

    /**
     * @param value SSL profile resource of the application gateway.
     */
    @JvmName("ruvyqpquvweendqc")
    public suspend fun sslProfile(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sslProfile = mapped
    }

    /**
     * @param argument SSL profile resource of the application gateway.
     */
    @JvmName("fdanerhndneotsiy")
    public suspend fun sslProfile(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sslProfile = mapped
    }

    internal fun build(): ApplicationGatewayHttpListenerArgs = ApplicationGatewayHttpListenerArgs(
        customErrorConfigurations = customErrorConfigurations,
        firewallPolicy = firewallPolicy,
        frontendIPConfiguration = frontendIPConfiguration,
        frontendPort = frontendPort,
        hostName = hostName,
        hostNames = hostNames,
        id = id,
        name = name,
        protocol = protocol,
        requireServerNameIndication = requireServerNameIndication,
        sslCertificate = sslCertificate,
        sslProfile = sslProfile,
    )
}
