@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ApplicationGatewayPathRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Path rule of URL path map of an application gateway.
 * @property backendAddressPool Backend address pool resource of URL path map path rule.
 * @property backendHttpSettings Backend http settings resource of URL path map path rule.
 * @property firewallPolicy Reference to the FirewallPolicy resource.
 * @property id Resource ID.
 * @property loadDistributionPolicy Load Distribution Policy resource of URL path map path rule.
 * @property name Name of the path rule that is unique within an Application Gateway.
 * @property paths Path rules of URL path map.
 * @property redirectConfiguration Redirect configuration resource of URL path map path rule.
 * @property rewriteRuleSet Rewrite rule set resource of URL path map path rule.
 */
public data class ApplicationGatewayPathRuleArgs(
    public val backendAddressPool: Output<SubResourceArgs>? = null,
    public val backendHttpSettings: Output<SubResourceArgs>? = null,
    public val firewallPolicy: Output<SubResourceArgs>? = null,
    public val id: Output<String>? = null,
    public val loadDistributionPolicy: Output<SubResourceArgs>? = null,
    public val name: Output<String>? = null,
    public val paths: Output<List<String>>? = null,
    public val redirectConfiguration: Output<SubResourceArgs>? = null,
    public val rewriteRuleSet: Output<SubResourceArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.ApplicationGatewayPathRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.ApplicationGatewayPathRuleArgs =
        com.pulumi.azurenative.network.inputs.ApplicationGatewayPathRuleArgs.builder()
            .backendAddressPool(
                backendAddressPool?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .backendHttpSettings(
                backendHttpSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .firewallPolicy(firewallPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .id(id?.applyValue({ args0 -> args0 }))
            .loadDistributionPolicy(
                loadDistributionPolicy?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .paths(paths?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .redirectConfiguration(
                redirectConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .rewriteRuleSet(
                rewriteRuleSet?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ApplicationGatewayPathRuleArgs].
 */
@PulumiTagMarker
public class ApplicationGatewayPathRuleArgsBuilder internal constructor() {
    private var backendAddressPool: Output<SubResourceArgs>? = null

    private var backendHttpSettings: Output<SubResourceArgs>? = null

    private var firewallPolicy: Output<SubResourceArgs>? = null

    private var id: Output<String>? = null

    private var loadDistributionPolicy: Output<SubResourceArgs>? = null

    private var name: Output<String>? = null

    private var paths: Output<List<String>>? = null

    private var redirectConfiguration: Output<SubResourceArgs>? = null

    private var rewriteRuleSet: Output<SubResourceArgs>? = null

    /**
     * @param value Backend address pool resource of URL path map path rule.
     */
    @JvmName("aaehmlqufljtkqdd")
    public suspend fun backendAddressPool(`value`: Output<SubResourceArgs>) {
        this.backendAddressPool = value
    }

    /**
     * @param value Backend http settings resource of URL path map path rule.
     */
    @JvmName("khrhiygdojjdfwwc")
    public suspend fun backendHttpSettings(`value`: Output<SubResourceArgs>) {
        this.backendHttpSettings = value
    }

    /**
     * @param value Reference to the FirewallPolicy resource.
     */
    @JvmName("pjlodjxptddpoarb")
    public suspend fun firewallPolicy(`value`: Output<SubResourceArgs>) {
        this.firewallPolicy = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("myffukrmwuonuscx")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Load Distribution Policy resource of URL path map path rule.
     */
    @JvmName("bugdkwxluydpmuiw")
    public suspend fun loadDistributionPolicy(`value`: Output<SubResourceArgs>) {
        this.loadDistributionPolicy = value
    }

    /**
     * @param value Name of the path rule that is unique within an Application Gateway.
     */
    @JvmName("fxsturcjsfkepdcc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Path rules of URL path map.
     */
    @JvmName("vqutmimeyhttbgkf")
    public suspend fun paths(`value`: Output<List<String>>) {
        this.paths = value
    }

    @JvmName("hfspgjsybymgfmqx")
    public suspend fun paths(vararg values: Output<String>) {
        this.paths = Output.all(values.asList())
    }

    /**
     * @param values Path rules of URL path map.
     */
    @JvmName("ugdtiqitvkieacpn")
    public suspend fun paths(values: List<Output<String>>) {
        this.paths = Output.all(values)
    }

    /**
     * @param value Redirect configuration resource of URL path map path rule.
     */
    @JvmName("odqhbunfxmpeajww")
    public suspend fun redirectConfiguration(`value`: Output<SubResourceArgs>) {
        this.redirectConfiguration = value
    }

    /**
     * @param value Rewrite rule set resource of URL path map path rule.
     */
    @JvmName("fnbijrckuvdtscxc")
    public suspend fun rewriteRuleSet(`value`: Output<SubResourceArgs>) {
        this.rewriteRuleSet = value
    }

    /**
     * @param value Backend address pool resource of URL path map path rule.
     */
    @JvmName("ruufypwctvwgpvov")
    public suspend fun backendAddressPool(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backendAddressPool = mapped
    }

    /**
     * @param argument Backend address pool resource of URL path map path rule.
     */
    @JvmName("xotqhrotrsopdjdi")
    public suspend fun backendAddressPool(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.backendAddressPool = mapped
    }

    /**
     * @param value Backend http settings resource of URL path map path rule.
     */
    @JvmName("iflxjexxtfhllypa")
    public suspend fun backendHttpSettings(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backendHttpSettings = mapped
    }

    /**
     * @param argument Backend http settings resource of URL path map path rule.
     */
    @JvmName("vokaourhcvblvulh")
    public suspend fun backendHttpSettings(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.backendHttpSettings = mapped
    }

    /**
     * @param value Reference to the FirewallPolicy resource.
     */
    @JvmName("cjdglvbkraqhcsek")
    public suspend fun firewallPolicy(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firewallPolicy = mapped
    }

    /**
     * @param argument Reference to the FirewallPolicy resource.
     */
    @JvmName("penxaipdiqfpefen")
    public suspend fun firewallPolicy(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.firewallPolicy = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("fhkngtbhrgofuaji")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Load Distribution Policy resource of URL path map path rule.
     */
    @JvmName("qwvrdmggchlxidhq")
    public suspend fun loadDistributionPolicy(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadDistributionPolicy = mapped
    }

    /**
     * @param argument Load Distribution Policy resource of URL path map path rule.
     */
    @JvmName("qsrkidkjvmrjvfmv")
    public suspend fun loadDistributionPolicy(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.loadDistributionPolicy = mapped
    }

    /**
     * @param value Name of the path rule that is unique within an Application Gateway.
     */
    @JvmName("pmsdfydjinavkgyl")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Path rules of URL path map.
     */
    @JvmName("wxejutdihallkdam")
    public suspend fun paths(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paths = mapped
    }

    /**
     * @param values Path rules of URL path map.
     */
    @JvmName("qfexhlynjprlvtnc")
    public suspend fun paths(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.paths = mapped
    }

    /**
     * @param value Redirect configuration resource of URL path map path rule.
     */
    @JvmName("ugqjvcmullwqemkh")
    public suspend fun redirectConfiguration(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.redirectConfiguration = mapped
    }

    /**
     * @param argument Redirect configuration resource of URL path map path rule.
     */
    @JvmName("oamgfjggkxbovfhh")
    public suspend fun redirectConfiguration(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.redirectConfiguration = mapped
    }

    /**
     * @param value Rewrite rule set resource of URL path map path rule.
     */
    @JvmName("tgctpelqwudimtou")
    public suspend fun rewriteRuleSet(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rewriteRuleSet = mapped
    }

    /**
     * @param argument Rewrite rule set resource of URL path map path rule.
     */
    @JvmName("jjxwwjjjtvnmirhw")
    public suspend fun rewriteRuleSet(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.rewriteRuleSet = mapped
    }

    internal fun build(): ApplicationGatewayPathRuleArgs = ApplicationGatewayPathRuleArgs(
        backendAddressPool = backendAddressPool,
        backendHttpSettings = backendHttpSettings,
        firewallPolicy = firewallPolicy,
        id = id,
        loadDistributionPolicy = loadDistributionPolicy,
        name = name,
        paths = paths,
        redirectConfiguration = redirectConfiguration,
        rewriteRuleSet = rewriteRuleSet,
    )
}
