@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ApplicationGatewayPrivateLinkIpConfigurationArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.IPAllocationMethod
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The application gateway private link ip configuration.
 * @property id Resource ID.
 * @property name The name of application gateway private link ip configuration.
 * @property primary Whether the ip configuration is primary or not.
 * @property privateIPAddress The private IP address of the IP configuration.
 * @property privateIPAllocationMethod The private IP address allocation method.
 * @property subnet Reference to the subnet resource.
 */
public data class ApplicationGatewayPrivateLinkIpConfigurationArgs(
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
    public val primary: Output<Boolean>? = null,
    public val privateIPAddress: Output<String>? = null,
    public val privateIPAllocationMethod: Output<Either<String, IPAllocationMethod>>? = null,
    public val subnet: Output<SubResourceArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.ApplicationGatewayPrivateLinkIpConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.ApplicationGatewayPrivateLinkIpConfigurationArgs =
        com.pulumi.azurenative.network.inputs.ApplicationGatewayPrivateLinkIpConfigurationArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .primary(primary?.applyValue({ args0 -> args0 }))
            .privateIPAddress(privateIPAddress?.applyValue({ args0 -> args0 }))
            .privateIPAllocationMethod(
                privateIPAllocationMethod?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .subnet(subnet?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ApplicationGatewayPrivateLinkIpConfigurationArgs].
 */
@PulumiTagMarker
public class ApplicationGatewayPrivateLinkIpConfigurationArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var primary: Output<Boolean>? = null

    private var privateIPAddress: Output<String>? = null

    private var privateIPAllocationMethod: Output<Either<String, IPAllocationMethod>>? = null

    private var subnet: Output<SubResourceArgs>? = null

    /**
     * @param value Resource ID.
     */
    @JvmName("tiqjffiemfgykluf")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The name of application gateway private link ip configuration.
     */
    @JvmName("cldewtnuxibbknxe")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Whether the ip configuration is primary or not.
     */
    @JvmName("pehjdsjefnnahghj")
    public suspend fun primary(`value`: Output<Boolean>) {
        this.primary = value
    }

    /**
     * @param value The private IP address of the IP configuration.
     */
    @JvmName("tgkgnnpvlrkfgmad")
    public suspend fun privateIPAddress(`value`: Output<String>) {
        this.privateIPAddress = value
    }

    /**
     * @param value The private IP address allocation method.
     */
    @JvmName("tqjvwnoullbmwibv")
    public suspend
    fun privateIPAllocationMethod(`value`: Output<Either<String, IPAllocationMethod>>) {
        this.privateIPAllocationMethod = value
    }

    /**
     * @param value Reference to the subnet resource.
     */
    @JvmName("ycgjtdrcgtiruiog")
    public suspend fun subnet(`value`: Output<SubResourceArgs>) {
        this.subnet = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("jgryaagthcowdobn")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The name of application gateway private link ip configuration.
     */
    @JvmName("vqmqwtlgothxooef")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Whether the ip configuration is primary or not.
     */
    @JvmName("bddpydwdhjijsknb")
    public suspend fun primary(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primary = mapped
    }

    /**
     * @param value The private IP address of the IP configuration.
     */
    @JvmName("lomskvqelgnvtsfk")
    public suspend fun privateIPAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateIPAddress = mapped
    }

    /**
     * @param value The private IP address allocation method.
     */
    @JvmName("xfushybqsbrhbusf")
    public suspend fun privateIPAllocationMethod(`value`: Either<String, IPAllocationMethod>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateIPAllocationMethod = mapped
    }

    /**
     * @param value The private IP address allocation method.
     */
    @JvmName("bexbgjkofyppoysb")
    public fun privateIPAllocationMethod(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IPAllocationMethod>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateIPAllocationMethod = mapped
    }

    /**
     * @param value The private IP address allocation method.
     */
    @JvmName("bljyfdjwghqosntw")
    public fun privateIPAllocationMethod(`value`: IPAllocationMethod) {
        val toBeMapped = Either.ofRight<String, IPAllocationMethod>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateIPAllocationMethod = mapped
    }

    /**
     * @param value Reference to the subnet resource.
     */
    @JvmName("acarctucssospuqg")
    public suspend fun subnet(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnet = mapped
    }

    /**
     * @param argument Reference to the subnet resource.
     */
    @JvmName("dohucmbsxdtkhxxm")
    public suspend fun subnet(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.subnet = mapped
    }

    internal fun build(): ApplicationGatewayPrivateLinkIpConfigurationArgs =
        ApplicationGatewayPrivateLinkIpConfigurationArgs(
            id = id,
            name = name,
            primary = primary,
            privateIPAddress = privateIPAddress,
            privateIPAllocationMethod = privateIPAllocationMethod,
            subnet = subnet,
        )
}
