@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ApplicationGatewayRequestRoutingRuleArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.ApplicationGatewayRequestRoutingRuleType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Request routing rule of an application gateway.
 * @property backendAddressPool Backend address pool resource of the application gateway.
 * @property backendHttpSettings Backend http settings resource of the application gateway.
 * @property httpListener Http listener resource of the application gateway.
 * @property id Resource ID.
 * @property loadDistributionPolicy Load Distribution Policy resource of the application gateway.
 * @property name Name of the request routing rule that is unique within an Application Gateway.
 * @property priority Priority of the request routing rule.
 * @property redirectConfiguration Redirect configuration resource of the application gateway.
 * @property rewriteRuleSet Rewrite Rule Set resource in Basic rule of the application gateway.
 * @property ruleType Rule type.
 * @property urlPathMap URL path map resource of the application gateway.
 */
public data class ApplicationGatewayRequestRoutingRuleArgs(
    public val backendAddressPool: Output<SubResourceArgs>? = null,
    public val backendHttpSettings: Output<SubResourceArgs>? = null,
    public val httpListener: Output<SubResourceArgs>? = null,
    public val id: Output<String>? = null,
    public val loadDistributionPolicy: Output<SubResourceArgs>? = null,
    public val name: Output<String>? = null,
    public val priority: Output<Int>? = null,
    public val redirectConfiguration: Output<SubResourceArgs>? = null,
    public val rewriteRuleSet: Output<SubResourceArgs>? = null,
    public val ruleType: Output<Either<String, ApplicationGatewayRequestRoutingRuleType>>? = null,
    public val urlPathMap: Output<SubResourceArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.ApplicationGatewayRequestRoutingRuleArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.ApplicationGatewayRequestRoutingRuleArgs =
        com.pulumi.azurenative.network.inputs.ApplicationGatewayRequestRoutingRuleArgs.builder()
            .backendAddressPool(
                backendAddressPool?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .backendHttpSettings(
                backendHttpSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .httpListener(httpListener?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .id(id?.applyValue({ args0 -> args0 }))
            .loadDistributionPolicy(
                loadDistributionPolicy?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .priority(priority?.applyValue({ args0 -> args0 }))
            .redirectConfiguration(
                redirectConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .rewriteRuleSet(rewriteRuleSet?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .ruleType(
                ruleType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .urlPathMap(urlPathMap?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ApplicationGatewayRequestRoutingRuleArgs].
 */
@PulumiTagMarker
public class ApplicationGatewayRequestRoutingRuleArgsBuilder internal constructor() {
    private var backendAddressPool: Output<SubResourceArgs>? = null

    private var backendHttpSettings: Output<SubResourceArgs>? = null

    private var httpListener: Output<SubResourceArgs>? = null

    private var id: Output<String>? = null

    private var loadDistributionPolicy: Output<SubResourceArgs>? = null

    private var name: Output<String>? = null

    private var priority: Output<Int>? = null

    private var redirectConfiguration: Output<SubResourceArgs>? = null

    private var rewriteRuleSet: Output<SubResourceArgs>? = null

    private var ruleType: Output<Either<String, ApplicationGatewayRequestRoutingRuleType>>? = null

    private var urlPathMap: Output<SubResourceArgs>? = null

    /**
     * @param value Backend address pool resource of the application gateway.
     */
    @JvmName("muuxfelikjpvwjhi")
    public suspend fun backendAddressPool(`value`: Output<SubResourceArgs>) {
        this.backendAddressPool = value
    }

    /**
     * @param value Backend http settings resource of the application gateway.
     */
    @JvmName("evguqhptqxamtgda")
    public suspend fun backendHttpSettings(`value`: Output<SubResourceArgs>) {
        this.backendHttpSettings = value
    }

    /**
     * @param value Http listener resource of the application gateway.
     */
    @JvmName("qrgusnyepynyable")
    public suspend fun httpListener(`value`: Output<SubResourceArgs>) {
        this.httpListener = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("xpwfbywrmnuqrymp")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Load Distribution Policy resource of the application gateway.
     */
    @JvmName("mbtnexpueqeyhcok")
    public suspend fun loadDistributionPolicy(`value`: Output<SubResourceArgs>) {
        this.loadDistributionPolicy = value
    }

    /**
     * @param value Name of the request routing rule that is unique within an Application Gateway.
     */
    @JvmName("rqrcrvmjkeistein")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Priority of the request routing rule.
     */
    @JvmName("kraqwljfdopigveh")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value Redirect configuration resource of the application gateway.
     */
    @JvmName("mcysjvqtamnfkjyk")
    public suspend fun redirectConfiguration(`value`: Output<SubResourceArgs>) {
        this.redirectConfiguration = value
    }

    /**
     * @param value Rewrite Rule Set resource in Basic rule of the application gateway.
     */
    @JvmName("cvhkuwxnkwyxceaq")
    public suspend fun rewriteRuleSet(`value`: Output<SubResourceArgs>) {
        this.rewriteRuleSet = value
    }

    /**
     * @param value Rule type.
     */
    @JvmName("dodxxdosvbjxyrwb")
    public suspend
    fun ruleType(`value`: Output<Either<String, ApplicationGatewayRequestRoutingRuleType>>) {
        this.ruleType = value
    }

    /**
     * @param value URL path map resource of the application gateway.
     */
    @JvmName("qpybuxeajhbfmwyk")
    public suspend fun urlPathMap(`value`: Output<SubResourceArgs>) {
        this.urlPathMap = value
    }

    /**
     * @param value Backend address pool resource of the application gateway.
     */
    @JvmName("pfombbgwpnebsbfr")
    public suspend fun backendAddressPool(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backendAddressPool = mapped
    }

    /**
     * @param argument Backend address pool resource of the application gateway.
     */
    @JvmName("bkdnnipemyffkjfs")
    public suspend fun backendAddressPool(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.backendAddressPool = mapped
    }

    /**
     * @param value Backend http settings resource of the application gateway.
     */
    @JvmName("xguwyosrordoekgr")
    public suspend fun backendHttpSettings(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backendHttpSettings = mapped
    }

    /**
     * @param argument Backend http settings resource of the application gateway.
     */
    @JvmName("wjbmadtlhueadjif")
    public suspend fun backendHttpSettings(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.backendHttpSettings = mapped
    }

    /**
     * @param value Http listener resource of the application gateway.
     */
    @JvmName("xndqhsiyyyiyjnxc")
    public suspend fun httpListener(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpListener = mapped
    }

    /**
     * @param argument Http listener resource of the application gateway.
     */
    @JvmName("fhsijdpyhiuegswf")
    public suspend fun httpListener(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.httpListener = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("ofcwsngecocikcre")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Load Distribution Policy resource of the application gateway.
     */
    @JvmName("udkqiipxbkeitynl")
    public suspend fun loadDistributionPolicy(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadDistributionPolicy = mapped
    }

    /**
     * @param argument Load Distribution Policy resource of the application gateway.
     */
    @JvmName("geoiviijoxaspegm")
    public suspend fun loadDistributionPolicy(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.loadDistributionPolicy = mapped
    }

    /**
     * @param value Name of the request routing rule that is unique within an Application Gateway.
     */
    @JvmName("nthjbljfqtmwvdly")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Priority of the request routing rule.
     */
    @JvmName("cmeklkvhsychtyxk")
    public suspend fun priority(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value Redirect configuration resource of the application gateway.
     */
    @JvmName("eceoefxiljqimsmx")
    public suspend fun redirectConfiguration(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.redirectConfiguration = mapped
    }

    /**
     * @param argument Redirect configuration resource of the application gateway.
     */
    @JvmName("wxjjvkwktkkpwesy")
    public suspend fun redirectConfiguration(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.redirectConfiguration = mapped
    }

    /**
     * @param value Rewrite Rule Set resource in Basic rule of the application gateway.
     */
    @JvmName("gkseujoqphvfjxde")
    public suspend fun rewriteRuleSet(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rewriteRuleSet = mapped
    }

    /**
     * @param argument Rewrite Rule Set resource in Basic rule of the application gateway.
     */
    @JvmName("gobahyoccwuaojhs")
    public suspend fun rewriteRuleSet(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.rewriteRuleSet = mapped
    }

    /**
     * @param value Rule type.
     */
    @JvmName("tajkecbuimrfukgv")
    public suspend fun ruleType(`value`: Either<String, ApplicationGatewayRequestRoutingRuleType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleType = mapped
    }

    /**
     * @param value Rule type.
     */
    @JvmName("xvicxavyhksliitk")
    public fun ruleType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ApplicationGatewayRequestRoutingRuleType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleType = mapped
    }

    /**
     * @param value Rule type.
     */
    @JvmName("iyjskjlgdledprre")
    public fun ruleType(`value`: ApplicationGatewayRequestRoutingRuleType) {
        val toBeMapped = Either.ofRight<String, ApplicationGatewayRequestRoutingRuleType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleType = mapped
    }

    /**
     * @param value URL path map resource of the application gateway.
     */
    @JvmName("afgxjkifluyfvhpf")
    public suspend fun urlPathMap(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.urlPathMap = mapped
    }

    /**
     * @param argument URL path map resource of the application gateway.
     */
    @JvmName("nxlaxjprhylxsabp")
    public suspend fun urlPathMap(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.urlPathMap = mapped
    }

    internal fun build(): ApplicationGatewayRequestRoutingRuleArgs =
        ApplicationGatewayRequestRoutingRuleArgs(
            backendAddressPool = backendAddressPool,
            backendHttpSettings = backendHttpSettings,
            httpListener = httpListener,
            id = id,
            loadDistributionPolicy = loadDistributionPolicy,
            name = name,
            priority = priority,
            redirectConfiguration = redirectConfiguration,
            rewriteRuleSet = rewriteRuleSet,
            ruleType = ruleType,
            urlPathMap = urlPathMap,
        )
}
