@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ApplicationGatewayRewriteRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Rewrite rule of an application gateway.
 * @property actionSet Set of actions to be done as part of the rewrite Rule.
 * @property conditions Conditions based on which the action set execution will be evaluated.
 * @property name Name of the rewrite rule that is unique within an Application Gateway.
 * @property ruleSequence Rule Sequence of the rewrite rule that determines the order of execution of a particular rule in a RewriteRuleSet.
 */
public data class ApplicationGatewayRewriteRuleArgs(
    public val actionSet: Output<ApplicationGatewayRewriteRuleActionSetArgs>? = null,
    public val conditions: Output<List<ApplicationGatewayRewriteRuleConditionArgs>>? = null,
    public val name: Output<String>? = null,
    public val ruleSequence: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.ApplicationGatewayRewriteRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.ApplicationGatewayRewriteRuleArgs =
        com.pulumi.azurenative.network.inputs.ApplicationGatewayRewriteRuleArgs.builder()
            .actionSet(actionSet?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .conditions(
                conditions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .ruleSequence(ruleSequence?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationGatewayRewriteRuleArgs].
 */
@PulumiTagMarker
public class ApplicationGatewayRewriteRuleArgsBuilder internal constructor() {
    private var actionSet: Output<ApplicationGatewayRewriteRuleActionSetArgs>? = null

    private var conditions: Output<List<ApplicationGatewayRewriteRuleConditionArgs>>? = null

    private var name: Output<String>? = null

    private var ruleSequence: Output<Int>? = null

    /**
     * @param value Set of actions to be done as part of the rewrite Rule.
     */
    @JvmName("fwxmobngrpgtdnux")
    public suspend fun actionSet(`value`: Output<ApplicationGatewayRewriteRuleActionSetArgs>) {
        this.actionSet = value
    }

    /**
     * @param value Conditions based on which the action set execution will be evaluated.
     */
    @JvmName("xnsoeybbniliwlrn")
    public suspend fun conditions(`value`: Output<List<ApplicationGatewayRewriteRuleConditionArgs>>) {
        this.conditions = value
    }

    @JvmName("hbmuwhrlgbhbhlgs")
    public suspend fun conditions(vararg values: Output<ApplicationGatewayRewriteRuleConditionArgs>) {
        this.conditions = Output.all(values.asList())
    }

    /**
     * @param values Conditions based on which the action set execution will be evaluated.
     */
    @JvmName("pognjoagvwucnuef")
    public suspend fun conditions(values: List<Output<ApplicationGatewayRewriteRuleConditionArgs>>) {
        this.conditions = Output.all(values)
    }

    /**
     * @param value Name of the rewrite rule that is unique within an Application Gateway.
     */
    @JvmName("cihdekqfpwgiglut")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Rule Sequence of the rewrite rule that determines the order of execution of a particular rule in a RewriteRuleSet.
     */
    @JvmName("lcnegjqpkgidqpfr")
    public suspend fun ruleSequence(`value`: Output<Int>) {
        this.ruleSequence = value
    }

    /**
     * @param value Set of actions to be done as part of the rewrite Rule.
     */
    @JvmName("fbmwfwyjxktckuyr")
    public suspend fun actionSet(`value`: ApplicationGatewayRewriteRuleActionSetArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actionSet = mapped
    }

    /**
     * @param argument Set of actions to be done as part of the rewrite Rule.
     */
    @JvmName("pcxuooggbotfdgmk")
    public suspend
    fun actionSet(argument: suspend ApplicationGatewayRewriteRuleActionSetArgsBuilder.() -> Unit) {
        val toBeMapped = ApplicationGatewayRewriteRuleActionSetArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.actionSet = mapped
    }

    /**
     * @param value Conditions based on which the action set execution will be evaluated.
     */
    @JvmName("vvtkeqpafkxrfdtu")
    public suspend fun conditions(`value`: List<ApplicationGatewayRewriteRuleConditionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.conditions = mapped
    }

    /**
     * @param argument Conditions based on which the action set execution will be evaluated.
     */
    @JvmName("jpxlgixewpucedcg")
    public suspend
    fun conditions(argument: List<suspend ApplicationGatewayRewriteRuleConditionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewayRewriteRuleConditionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.conditions = mapped
    }

    /**
     * @param argument Conditions based on which the action set execution will be evaluated.
     */
    @JvmName("aikvmqfqyrtpdxfg")
    public suspend fun conditions(
        vararg
        argument: suspend ApplicationGatewayRewriteRuleConditionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewayRewriteRuleConditionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.conditions = mapped
    }

    /**
     * @param argument Conditions based on which the action set execution will be evaluated.
     */
    @JvmName("tfauqpgrluqwyqbf")
    public suspend
    fun conditions(argument: suspend ApplicationGatewayRewriteRuleConditionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ApplicationGatewayRewriteRuleConditionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.conditions = mapped
    }

    /**
     * @param values Conditions based on which the action set execution will be evaluated.
     */
    @JvmName("bioaigtrvqxfwbql")
    public suspend fun conditions(vararg values: ApplicationGatewayRewriteRuleConditionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.conditions = mapped
    }

    /**
     * @param value Name of the rewrite rule that is unique within an Application Gateway.
     */
    @JvmName("uncyqmvnqnltcrsp")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Rule Sequence of the rewrite rule that determines the order of execution of a particular rule in a RewriteRuleSet.
     */
    @JvmName("nmictgldxskruuvm")
    public suspend fun ruleSequence(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleSequence = mapped
    }

    internal fun build(): ApplicationGatewayRewriteRuleArgs = ApplicationGatewayRewriteRuleArgs(
        actionSet = actionSet,
        conditions = conditions,
        name = name,
        ruleSequence = ruleSequence,
    )
}
