@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ApplicationGatewayRewriteRuleConditionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Set of conditions in the Rewrite Rule in Application Gateway.
 * @property ignoreCase Setting this parameter to truth value with force the pattern to do a case in-sensitive comparison.
 * @property negate Setting this value as truth will force to check the negation of the condition given by the user.
 * @property pattern The pattern, either fixed string or regular expression, that evaluates the truthfulness of the condition.
 * @property variable The condition parameter of the RewriteRuleCondition.
 */
public data class ApplicationGatewayRewriteRuleConditionArgs(
    public val ignoreCase: Output<Boolean>? = null,
    public val negate: Output<Boolean>? = null,
    public val pattern: Output<String>? = null,
    public val variable: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.ApplicationGatewayRewriteRuleConditionArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.ApplicationGatewayRewriteRuleConditionArgs =
        com.pulumi.azurenative.network.inputs.ApplicationGatewayRewriteRuleConditionArgs.builder()
            .ignoreCase(ignoreCase?.applyValue({ args0 -> args0 }))
            .negate(negate?.applyValue({ args0 -> args0 }))
            .pattern(pattern?.applyValue({ args0 -> args0 }))
            .variable(variable?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationGatewayRewriteRuleConditionArgs].
 */
@PulumiTagMarker
public class ApplicationGatewayRewriteRuleConditionArgsBuilder internal constructor() {
    private var ignoreCase: Output<Boolean>? = null

    private var negate: Output<Boolean>? = null

    private var pattern: Output<String>? = null

    private var variable: Output<String>? = null

    /**
     * @param value Setting this parameter to truth value with force the pattern to do a case in-sensitive comparison.
     */
    @JvmName("ngdlkanefvdntyix")
    public suspend fun ignoreCase(`value`: Output<Boolean>) {
        this.ignoreCase = value
    }

    /**
     * @param value Setting this value as truth will force to check the negation of the condition given by the user.
     */
    @JvmName("jbyaumaoivibbjkp")
    public suspend fun negate(`value`: Output<Boolean>) {
        this.negate = value
    }

    /**
     * @param value The pattern, either fixed string or regular expression, that evaluates the truthfulness of the condition.
     */
    @JvmName("wvufictveemxlwgh")
    public suspend fun pattern(`value`: Output<String>) {
        this.pattern = value
    }

    /**
     * @param value The condition parameter of the RewriteRuleCondition.
     */
    @JvmName("yhuwnexplhahotcc")
    public suspend fun variable(`value`: Output<String>) {
        this.variable = value
    }

    /**
     * @param value Setting this parameter to truth value with force the pattern to do a case in-sensitive comparison.
     */
    @JvmName("qygefgvvdncahsya")
    public suspend fun ignoreCase(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ignoreCase = mapped
    }

    /**
     * @param value Setting this value as truth will force to check the negation of the condition given by the user.
     */
    @JvmName("xtqrfgoyysejomtw")
    public suspend fun negate(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.negate = mapped
    }

    /**
     * @param value The pattern, either fixed string or regular expression, that evaluates the truthfulness of the condition.
     */
    @JvmName("ikhutwncgrbjetht")
    public suspend fun pattern(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pattern = mapped
    }

    /**
     * @param value The condition parameter of the RewriteRuleCondition.
     */
    @JvmName("ypwiupduxorpfpac")
    public suspend fun variable(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.variable = mapped
    }

    internal fun build(): ApplicationGatewayRewriteRuleConditionArgs =
        ApplicationGatewayRewriteRuleConditionArgs(
            ignoreCase = ignoreCase,
            negate = negate,
            pattern = pattern,
            variable = variable,
        )
}
