@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.AzureFirewallApplicationRuleProtocolArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.AzureFirewallApplicationRuleProtocolType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Properties of the application rule protocol.
 * @property port Port number for the protocol, cannot be greater than 64000. This field is optional.
 * @property protocolType Protocol type.
 */
public data class AzureFirewallApplicationRuleProtocolArgs(
    public val port: Output<Int>? = null,
    public val protocolType: Output<Either<String, AzureFirewallApplicationRuleProtocolType>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.AzureFirewallApplicationRuleProtocolArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.AzureFirewallApplicationRuleProtocolArgs =
        com.pulumi.azurenative.network.inputs.AzureFirewallApplicationRuleProtocolArgs.builder()
            .port(port?.applyValue({ args0 -> args0 }))
            .protocolType(
                protocolType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [AzureFirewallApplicationRuleProtocolArgs].
 */
@PulumiTagMarker
public class AzureFirewallApplicationRuleProtocolArgsBuilder internal constructor() {
    private var port: Output<Int>? = null

    private var protocolType: Output<Either<String, AzureFirewallApplicationRuleProtocolType>>? = null

    /**
     * @param value Port number for the protocol, cannot be greater than 64000. This field is optional.
     */
    @JvmName("odfdoikrwlfbsnym")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value Protocol type.
     */
    @JvmName("ekjnyqlcxcywedxw")
    public suspend
    fun protocolType(`value`: Output<Either<String, AzureFirewallApplicationRuleProtocolType>>) {
        this.protocolType = value
    }

    /**
     * @param value Port number for the protocol, cannot be greater than 64000. This field is optional.
     */
    @JvmName("oqnqcnthqrllpwdy")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value Protocol type.
     */
    @JvmName("hlkrievyqgysxuig")
    public suspend
    fun protocolType(`value`: Either<String, AzureFirewallApplicationRuleProtocolType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocolType = mapped
    }

    /**
     * @param value Protocol type.
     */
    @JvmName("kqenwjwyvdpdsylb")
    public fun protocolType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AzureFirewallApplicationRuleProtocolType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocolType = mapped
    }

    /**
     * @param value Protocol type.
     */
    @JvmName("kambjddyilqfmutu")
    public fun protocolType(`value`: AzureFirewallApplicationRuleProtocolType) {
        val toBeMapped = Either.ofRight<String, AzureFirewallApplicationRuleProtocolType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocolType = mapped
    }

    internal fun build(): AzureFirewallApplicationRuleProtocolArgs =
        AzureFirewallApplicationRuleProtocolArgs(
            port = port,
            protocolType = protocolType,
        )
}
