@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.BackendPoolsSettingsArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.EnforceCertificateNameCheckEnabledState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Settings that apply to all backend pools.
 * @property enforceCertificateNameCheck Whether to enforce certificate name check on HTTPS requests to all backend pools. No effect on non-HTTPS requests.
 * @property sendRecvTimeoutSeconds Send and receive timeout on forwarding request to the backend. When timeout is reached, the request fails and returns.
 */
public data class BackendPoolsSettingsArgs(
    public val enforceCertificateNameCheck:
    Output<Either<String, EnforceCertificateNameCheckEnabledState>>? = null,
    public val sendRecvTimeoutSeconds: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.BackendPoolsSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.BackendPoolsSettingsArgs =
        com.pulumi.azurenative.network.inputs.BackendPoolsSettingsArgs.builder()
            .enforceCertificateNameCheck(
                enforceCertificateNameCheck?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .sendRecvTimeoutSeconds(sendRecvTimeoutSeconds?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BackendPoolsSettingsArgs].
 */
@PulumiTagMarker
public class BackendPoolsSettingsArgsBuilder internal constructor() {
    private var enforceCertificateNameCheck:
        Output<Either<String, EnforceCertificateNameCheckEnabledState>>? = null

    private var sendRecvTimeoutSeconds: Output<Int>? = null

    /**
     * @param value Whether to enforce certificate name check on HTTPS requests to all backend pools. No effect on non-HTTPS requests.
     */
    @JvmName("xkeunfkcouqchnuh")
    public suspend
    fun enforceCertificateNameCheck(`value`: Output<Either<String, EnforceCertificateNameCheckEnabledState>>) {
        this.enforceCertificateNameCheck = value
    }

    /**
     * @param value Send and receive timeout on forwarding request to the backend. When timeout is reached, the request fails and returns.
     */
    @JvmName("olbgdxyqyoyqqoqo")
    public suspend fun sendRecvTimeoutSeconds(`value`: Output<Int>) {
        this.sendRecvTimeoutSeconds = value
    }

    /**
     * @param value Whether to enforce certificate name check on HTTPS requests to all backend pools. No effect on non-HTTPS requests.
     */
    @JvmName("xiqonwulddcbnoov")
    public suspend
    fun enforceCertificateNameCheck(`value`: Either<String, EnforceCertificateNameCheckEnabledState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enforceCertificateNameCheck = mapped
    }

    /**
     * @param value Whether to enforce certificate name check on HTTPS requests to all backend pools. No effect on non-HTTPS requests.
     */
    @JvmName("yimkrawfclcqwkre")
    public fun enforceCertificateNameCheck(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EnforceCertificateNameCheckEnabledState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enforceCertificateNameCheck = mapped
    }

    /**
     * @param value Whether to enforce certificate name check on HTTPS requests to all backend pools. No effect on non-HTTPS requests.
     */
    @JvmName("dmrodbpdgdikbaeq")
    public fun enforceCertificateNameCheck(`value`: EnforceCertificateNameCheckEnabledState) {
        val toBeMapped = Either.ofRight<String, EnforceCertificateNameCheckEnabledState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enforceCertificateNameCheck = mapped
    }

    /**
     * @param value Send and receive timeout on forwarding request to the backend. When timeout is reached, the request fails and returns.
     */
    @JvmName("diifahtejphnfqqu")
    public suspend fun sendRecvTimeoutSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sendRecvTimeoutSeconds = mapped
    }

    internal fun build(): BackendPoolsSettingsArgs = BackendPoolsSettingsArgs(
        enforceCertificateNameCheck = enforceCertificateNameCheck,
        sendRecvTimeoutSeconds = sendRecvTimeoutSeconds,
    )
}
