@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.BastionHostIPConfigurationArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.IPAllocationMethod
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * IP configuration of an Bastion Host.
 * @property id Resource ID.
 * @property name Name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property privateIPAllocationMethod Private IP allocation method.
 * @property publicIPAddress Reference of the PublicIP resource.
 * @property subnet Reference of the subnet resource.
 */
public data class BastionHostIPConfigurationArgs(
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
    public val privateIPAllocationMethod: Output<Either<String, IPAllocationMethod>>? = null,
    public val publicIPAddress: Output<SubResourceArgs>,
    public val subnet: Output<SubResourceArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.BastionHostIPConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.BastionHostIPConfigurationArgs =
        com.pulumi.azurenative.network.inputs.BastionHostIPConfigurationArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .privateIPAllocationMethod(
                privateIPAllocationMethod?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .publicIPAddress(publicIPAddress.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .subnet(subnet.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [BastionHostIPConfigurationArgs].
 */
@PulumiTagMarker
public class BastionHostIPConfigurationArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var privateIPAllocationMethod: Output<Either<String, IPAllocationMethod>>? = null

    private var publicIPAddress: Output<SubResourceArgs>? = null

    private var subnet: Output<SubResourceArgs>? = null

    /**
     * @param value Resource ID.
     */
    @JvmName("hcwajaifdgvkaohb")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("heclcmctftbvjlrp")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Private IP allocation method.
     */
    @JvmName("pyhbtchjaucjiokj")
    public suspend
    fun privateIPAllocationMethod(`value`: Output<Either<String, IPAllocationMethod>>) {
        this.privateIPAllocationMethod = value
    }

    /**
     * @param value Reference of the PublicIP resource.
     */
    @JvmName("ssnwdhpitwkstenc")
    public suspend fun publicIPAddress(`value`: Output<SubResourceArgs>) {
        this.publicIPAddress = value
    }

    /**
     * @param value Reference of the subnet resource.
     */
    @JvmName("ckalqhuanxeqkgru")
    public suspend fun subnet(`value`: Output<SubResourceArgs>) {
        this.subnet = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("gdiybmmaprnowbmx")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("xachugkovchauusw")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Private IP allocation method.
     */
    @JvmName("atarpciqvifygove")
    public suspend fun privateIPAllocationMethod(`value`: Either<String, IPAllocationMethod>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateIPAllocationMethod = mapped
    }

    /**
     * @param value Private IP allocation method.
     */
    @JvmName("paygodncwqirhkhk")
    public fun privateIPAllocationMethod(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IPAllocationMethod>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateIPAllocationMethod = mapped
    }

    /**
     * @param value Private IP allocation method.
     */
    @JvmName("dpfjnjvjveshsgrd")
    public fun privateIPAllocationMethod(`value`: IPAllocationMethod) {
        val toBeMapped = Either.ofRight<String, IPAllocationMethod>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateIPAllocationMethod = mapped
    }

    /**
     * @param value Reference of the PublicIP resource.
     */
    @JvmName("cxnsjnsinxfrmydj")
    public suspend fun publicIPAddress(`value`: SubResourceArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicIPAddress = mapped
    }

    /**
     * @param argument Reference of the PublicIP resource.
     */
    @JvmName("acxdtvjkeylxwput")
    public suspend fun publicIPAddress(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.publicIPAddress = mapped
    }

    /**
     * @param value Reference of the subnet resource.
     */
    @JvmName("aelrgawhdhcyuceb")
    public suspend fun subnet(`value`: SubResourceArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnet = mapped
    }

    /**
     * @param argument Reference of the subnet resource.
     */
    @JvmName("wlfagneiynfjlprp")
    public suspend fun subnet(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.subnet = mapped
    }

    internal fun build(): BastionHostIPConfigurationArgs = BastionHostIPConfigurationArgs(
        id = id,
        name = name,
        privateIPAllocationMethod = privateIPAllocationMethod,
        publicIPAddress = publicIPAddress ?: throw PulumiNullFieldException("publicIPAddress"),
        subnet = subnet ?: throw PulumiNullFieldException("subnet"),
    )
}
