@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.BreakOutCategoryPoliciesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Network Virtual Appliance Sku Properties.
 * @property allow Flag to control breakout of o365 allow category.
 * @property default Flag to control breakout of o365 default category.
 * @property optimize Flag to control breakout of o365 optimize category.
 */
public data class BreakOutCategoryPoliciesArgs(
    public val allow: Output<Boolean>? = null,
    public val default: Output<Boolean>? = null,
    public val optimize: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.BreakOutCategoryPoliciesArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.BreakOutCategoryPoliciesArgs =
        com.pulumi.azurenative.network.inputs.BreakOutCategoryPoliciesArgs.builder()
            .allow(allow?.applyValue({ args0 -> args0 }))
            .default_(default?.applyValue({ args0 -> args0 }))
            .optimize(optimize?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BreakOutCategoryPoliciesArgs].
 */
@PulumiTagMarker
public class BreakOutCategoryPoliciesArgsBuilder internal constructor() {
    private var allow: Output<Boolean>? = null

    private var default: Output<Boolean>? = null

    private var optimize: Output<Boolean>? = null

    /**
     * @param value Flag to control breakout of o365 allow category.
     */
    @JvmName("bnantmksyvuxjcwx")
    public suspend fun allow(`value`: Output<Boolean>) {
        this.allow = value
    }

    /**
     * @param value Flag to control breakout of o365 default category.
     */
    @JvmName("pybxwywgqcjtejmk")
    public suspend fun default(`value`: Output<Boolean>) {
        this.default = value
    }

    /**
     * @param value Flag to control breakout of o365 optimize category.
     */
    @JvmName("fokshopsdesjlpwb")
    public suspend fun optimize(`value`: Output<Boolean>) {
        this.optimize = value
    }

    /**
     * @param value Flag to control breakout of o365 allow category.
     */
    @JvmName("glbckiauiwokhyhx")
    public suspend fun allow(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allow = mapped
    }

    /**
     * @param value Flag to control breakout of o365 default category.
     */
    @JvmName("vpabechlsltpwecc")
    public suspend fun default(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.default = mapped
    }

    /**
     * @param value Flag to control breakout of o365 optimize category.
     */
    @JvmName("pumpawjuaoiyvsyq")
    public suspend fun optimize(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.optimize = mapped
    }

    internal fun build(): BreakOutCategoryPoliciesArgs = BreakOutCategoryPoliciesArgs(
        allow = allow,
        default = default,
        optimize = optimize,
    )
}
