@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.CacheConfigurationArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.DynamicCompressionEnabled
import com.pulumi.azurenative.network.kotlin.enums.FrontDoorQuery
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Caching settings for a caching-type route. To disable caching, do not provide a cacheConfiguration object.
 * @property cacheDuration The duration for which the content needs to be cached. Allowed format is in ISO 8601 format (http://en.wikipedia.org/wiki/ISO_8601#Durations). HTTP requires the value to be no more than a year
 * @property dynamicCompression Whether to use dynamic compression for cached content
 * @property queryParameterStripDirective Treatment of URL query terms when forming the cache key.
 * @property queryParameters query parameters to include or exclude (comma separated).
 */
public data class CacheConfigurationArgs(
    public val cacheDuration: Output<String>? = null,
    public val dynamicCompression: Output<Either<String, DynamicCompressionEnabled>>? = null,
    public val queryParameterStripDirective: Output<Either<String, FrontDoorQuery>>? = null,
    public val queryParameters: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.CacheConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.CacheConfigurationArgs =
        com.pulumi.azurenative.network.inputs.CacheConfigurationArgs.builder()
            .cacheDuration(cacheDuration?.applyValue({ args0 -> args0 }))
            .dynamicCompression(
                dynamicCompression?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .queryParameterStripDirective(
                queryParameterStripDirective?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .queryParameters(queryParameters?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CacheConfigurationArgs].
 */
@PulumiTagMarker
public class CacheConfigurationArgsBuilder internal constructor() {
    private var cacheDuration: Output<String>? = null

    private var dynamicCompression: Output<Either<String, DynamicCompressionEnabled>>? = null

    private var queryParameterStripDirective: Output<Either<String, FrontDoorQuery>>? = null

    private var queryParameters: Output<String>? = null

    /**
     * @param value The duration for which the content needs to be cached. Allowed format is in ISO 8601 format (http://en.wikipedia.org/wiki/ISO_8601#Durations). HTTP requires the value to be no more than a year
     */
    @JvmName("elmaugqvdccgvsxt")
    public suspend fun cacheDuration(`value`: Output<String>) {
        this.cacheDuration = value
    }

    /**
     * @param value Whether to use dynamic compression for cached content
     */
    @JvmName("ftocnkrvlheamwbl")
    public suspend
    fun dynamicCompression(`value`: Output<Either<String, DynamicCompressionEnabled>>) {
        this.dynamicCompression = value
    }

    /**
     * @param value Treatment of URL query terms when forming the cache key.
     */
    @JvmName("jkomucwrxamrlixt")
    public suspend fun queryParameterStripDirective(`value`: Output<Either<String, FrontDoorQuery>>) {
        this.queryParameterStripDirective = value
    }

    /**
     * @param value query parameters to include or exclude (comma separated).
     */
    @JvmName("soqqhgeigrprijdn")
    public suspend fun queryParameters(`value`: Output<String>) {
        this.queryParameters = value
    }

    /**
     * @param value The duration for which the content needs to be cached. Allowed format is in ISO 8601 format (http://en.wikipedia.org/wiki/ISO_8601#Durations). HTTP requires the value to be no more than a year
     */
    @JvmName("tucaaudmekdfqmmg")
    public suspend fun cacheDuration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cacheDuration = mapped
    }

    /**
     * @param value Whether to use dynamic compression for cached content
     */
    @JvmName("nljsjqvqxcdhvfyb")
    public suspend fun dynamicCompression(`value`: Either<String, DynamicCompressionEnabled>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dynamicCompression = mapped
    }

    /**
     * @param value Whether to use dynamic compression for cached content
     */
    @JvmName("lnntypqduqswcwto")
    public fun dynamicCompression(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DynamicCompressionEnabled>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dynamicCompression = mapped
    }

    /**
     * @param value Whether to use dynamic compression for cached content
     */
    @JvmName("fqetnudgowlweqan")
    public fun dynamicCompression(`value`: DynamicCompressionEnabled) {
        val toBeMapped = Either.ofRight<String, DynamicCompressionEnabled>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dynamicCompression = mapped
    }

    /**
     * @param value Treatment of URL query terms when forming the cache key.
     */
    @JvmName("rtrgucvukacujfdo")
    public suspend fun queryParameterStripDirective(`value`: Either<String, FrontDoorQuery>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryParameterStripDirective = mapped
    }

    /**
     * @param value Treatment of URL query terms when forming the cache key.
     */
    @JvmName("kxnmssbemopkqqhs")
    public fun queryParameterStripDirective(`value`: String) {
        val toBeMapped = Either.ofLeft<String, FrontDoorQuery>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.queryParameterStripDirective = mapped
    }

    /**
     * @param value Treatment of URL query terms when forming the cache key.
     */
    @JvmName("dhvhklvldmcptsbk")
    public fun queryParameterStripDirective(`value`: FrontDoorQuery) {
        val toBeMapped = Either.ofRight<String, FrontDoorQuery>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.queryParameterStripDirective = mapped
    }

    /**
     * @param value query parameters to include or exclude (comma separated).
     */
    @JvmName("veueixkanklppfeh")
    public suspend fun queryParameters(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryParameters = mapped
    }

    internal fun build(): CacheConfigurationArgs = CacheConfigurationArgs(
        cacheDuration = cacheDuration,
        dynamicCompression = dynamicCompression,
        queryParameterStripDirective = queryParameterStripDirective,
        queryParameters = queryParameters,
    )
}
