@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ConnectionMonitorEndpointArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.CoverageLevel
import com.pulumi.azurenative.network.kotlin.enums.EndpointType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Describes the connection monitor endpoint.
 * @property address Address of the connection monitor endpoint (IP or domain name).
 * @property coverageLevel Test coverage for the endpoint.
 * @property filter Filter for sub-items within the endpoint.
 * @property name The name of the connection monitor endpoint.
 * @property resourceId Resource ID of the connection monitor endpoint.
 * @property scope Endpoint scope.
 * @property type The endpoint type.
 */
public data class ConnectionMonitorEndpointArgs(
    public val address: Output<String>? = null,
    public val coverageLevel: Output<Either<String, CoverageLevel>>? = null,
    public val filter: Output<ConnectionMonitorEndpointFilterArgs>? = null,
    public val name: Output<String>,
    public val resourceId: Output<String>? = null,
    public val scope: Output<ConnectionMonitorEndpointScopeArgs>? = null,
    public val type: Output<Either<String, EndpointType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.ConnectionMonitorEndpointArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.ConnectionMonitorEndpointArgs =
        com.pulumi.azurenative.network.inputs.ConnectionMonitorEndpointArgs.builder()
            .address(address?.applyValue({ args0 -> args0 }))
            .coverageLevel(
                coverageLevel?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .filter(filter?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name.applyValue({ args0 -> args0 }))
            .resourceId(resourceId?.applyValue({ args0 -> args0 }))
            .scope(scope?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ConnectionMonitorEndpointArgs].
 */
@PulumiTagMarker
public class ConnectionMonitorEndpointArgsBuilder internal constructor() {
    private var address: Output<String>? = null

    private var coverageLevel: Output<Either<String, CoverageLevel>>? = null

    private var filter: Output<ConnectionMonitorEndpointFilterArgs>? = null

    private var name: Output<String>? = null

    private var resourceId: Output<String>? = null

    private var scope: Output<ConnectionMonitorEndpointScopeArgs>? = null

    private var type: Output<Either<String, EndpointType>>? = null

    /**
     * @param value Address of the connection monitor endpoint (IP or domain name).
     */
    @JvmName("vjgsaujimuebvgwx")
    public suspend fun address(`value`: Output<String>) {
        this.address = value
    }

    /**
     * @param value Test coverage for the endpoint.
     */
    @JvmName("caejmvfwxxrlxaqo")
    public suspend fun coverageLevel(`value`: Output<Either<String, CoverageLevel>>) {
        this.coverageLevel = value
    }

    /**
     * @param value Filter for sub-items within the endpoint.
     */
    @JvmName("jthxgskkshrmdurb")
    public suspend fun filter(`value`: Output<ConnectionMonitorEndpointFilterArgs>) {
        this.filter = value
    }

    /**
     * @param value The name of the connection monitor endpoint.
     */
    @JvmName("sqxlnapwiblfpyyw")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Resource ID of the connection monitor endpoint.
     */
    @JvmName("gptqqkcmbuqmgumu")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value Endpoint scope.
     */
    @JvmName("nbkttnsxerrfnkpb")
    public suspend fun scope(`value`: Output<ConnectionMonitorEndpointScopeArgs>) {
        this.scope = value
    }

    /**
     * @param value The endpoint type.
     */
    @JvmName("ndvptlaijkxruixs")
    public suspend fun type(`value`: Output<Either<String, EndpointType>>) {
        this.type = value
    }

    /**
     * @param value Address of the connection monitor endpoint (IP or domain name).
     */
    @JvmName("tmhlxkrjtrkcktnm")
    public suspend fun address(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.address = mapped
    }

    /**
     * @param value Test coverage for the endpoint.
     */
    @JvmName("prjdcdejwecqpbir")
    public suspend fun coverageLevel(`value`: Either<String, CoverageLevel>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.coverageLevel = mapped
    }

    /**
     * @param value Test coverage for the endpoint.
     */
    @JvmName("hxhchdcqmnvhewmn")
    public fun coverageLevel(`value`: String) {
        val toBeMapped = Either.ofLeft<String, CoverageLevel>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.coverageLevel = mapped
    }

    /**
     * @param value Test coverage for the endpoint.
     */
    @JvmName("kowlsmnapwftmhsv")
    public fun coverageLevel(`value`: CoverageLevel) {
        val toBeMapped = Either.ofRight<String, CoverageLevel>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.coverageLevel = mapped
    }

    /**
     * @param value Filter for sub-items within the endpoint.
     */
    @JvmName("xafteyonnxrfcvrj")
    public suspend fun filter(`value`: ConnectionMonitorEndpointFilterArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filter = mapped
    }

    /**
     * @param argument Filter for sub-items within the endpoint.
     */
    @JvmName("wagjmhrrvxvinwfm")
    public suspend
    fun filter(argument: suspend ConnectionMonitorEndpointFilterArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectionMonitorEndpointFilterArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.filter = mapped
    }

    /**
     * @param value The name of the connection monitor endpoint.
     */
    @JvmName("kecqghnnuvyynbyu")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Resource ID of the connection monitor endpoint.
     */
    @JvmName("tiiyqachxypllnwf")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    /**
     * @param value Endpoint scope.
     */
    @JvmName("jwfmhaujfeabygrl")
    public suspend fun scope(`value`: ConnectionMonitorEndpointScopeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param argument Endpoint scope.
     */
    @JvmName("hqjpxaefrxdnkgkp")
    public suspend fun scope(argument: suspend ConnectionMonitorEndpointScopeArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectionMonitorEndpointScopeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.scope = mapped
    }

    /**
     * @param value The endpoint type.
     */
    @JvmName("ciltkjhpgnbojsyr")
    public suspend fun type(`value`: Either<String, EndpointType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The endpoint type.
     */
    @JvmName("oknniqretjgjgish")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EndpointType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The endpoint type.
     */
    @JvmName("wmthfrbeaiektlsu")
    public fun type(`value`: EndpointType) {
        val toBeMapped = Either.ofRight<String, EndpointType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ConnectionMonitorEndpointArgs = ConnectionMonitorEndpointArgs(
        address = address,
        coverageLevel = coverageLevel,
        filter = filter,
        name = name ?: throw PulumiNullFieldException("name"),
        resourceId = resourceId,
        scope = scope,
        type = type,
    )
}
