@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ConnectionMonitorEndpointFilterArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.ConnectionMonitorEndpointFilterType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Describes the connection monitor endpoint filter.
 * @property items List of items in the filter.
 * @property type The behavior of the endpoint filter. Currently only 'Include' is supported.
 */
public data class ConnectionMonitorEndpointFilterArgs(
    public val items: Output<List<ConnectionMonitorEndpointFilterItemArgs>>? = null,
    public val type: Output<Either<String, ConnectionMonitorEndpointFilterType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.ConnectionMonitorEndpointFilterArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.ConnectionMonitorEndpointFilterArgs =
        com.pulumi.azurenative.network.inputs.ConnectionMonitorEndpointFilterArgs.builder()
            .items(items?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ConnectionMonitorEndpointFilterArgs].
 */
@PulumiTagMarker
public class ConnectionMonitorEndpointFilterArgsBuilder internal constructor() {
    private var items: Output<List<ConnectionMonitorEndpointFilterItemArgs>>? = null

    private var type: Output<Either<String, ConnectionMonitorEndpointFilterType>>? = null

    /**
     * @param value List of items in the filter.
     */
    @JvmName("rsbeccpswwaeqpoh")
    public suspend fun items(`value`: Output<List<ConnectionMonitorEndpointFilterItemArgs>>) {
        this.items = value
    }

    @JvmName("fiyhwauvpfynnvuu")
    public suspend fun items(vararg values: Output<ConnectionMonitorEndpointFilterItemArgs>) {
        this.items = Output.all(values.asList())
    }

    /**
     * @param values List of items in the filter.
     */
    @JvmName("ixeumjvevolvopgc")
    public suspend fun items(values: List<Output<ConnectionMonitorEndpointFilterItemArgs>>) {
        this.items = Output.all(values)
    }

    /**
     * @param value The behavior of the endpoint filter. Currently only 'Include' is supported.
     */
    @JvmName("kuxqvupiciinvpyg")
    public suspend fun type(`value`: Output<Either<String, ConnectionMonitorEndpointFilterType>>) {
        this.type = value
    }

    /**
     * @param value List of items in the filter.
     */
    @JvmName("ntdchewqrkwjvldf")
    public suspend fun items(`value`: List<ConnectionMonitorEndpointFilterItemArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.items = mapped
    }

    /**
     * @param argument List of items in the filter.
     */
    @JvmName("alakdxksiriglsqe")
    public suspend
    fun items(argument: List<suspend ConnectionMonitorEndpointFilterItemArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ConnectionMonitorEndpointFilterItemArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.items = mapped
    }

    /**
     * @param argument List of items in the filter.
     */
    @JvmName("ilwhcftieldngtiv")
    public suspend fun items(
        vararg
        argument: suspend ConnectionMonitorEndpointFilterItemArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ConnectionMonitorEndpointFilterItemArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.items = mapped
    }

    /**
     * @param argument List of items in the filter.
     */
    @JvmName("kpiylpvitdshxgdd")
    public suspend
    fun items(argument: suspend ConnectionMonitorEndpointFilterItemArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ConnectionMonitorEndpointFilterItemArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.items = mapped
    }

    /**
     * @param values List of items in the filter.
     */
    @JvmName("rpjdllcxkkswirvd")
    public suspend fun items(vararg values: ConnectionMonitorEndpointFilterItemArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.items = mapped
    }

    /**
     * @param value The behavior of the endpoint filter. Currently only 'Include' is supported.
     */
    @JvmName("wlnlpciyqohqfdsv")
    public suspend fun type(`value`: Either<String, ConnectionMonitorEndpointFilterType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The behavior of the endpoint filter. Currently only 'Include' is supported.
     */
    @JvmName("dohwosobcifjanjm")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ConnectionMonitorEndpointFilterType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The behavior of the endpoint filter. Currently only 'Include' is supported.
     */
    @JvmName("vcgtvmjuvpdpcnbw")
    public fun type(`value`: ConnectionMonitorEndpointFilterType) {
        val toBeMapped = Either.ofRight<String, ConnectionMonitorEndpointFilterType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ConnectionMonitorEndpointFilterArgs = ConnectionMonitorEndpointFilterArgs(
        items = items,
        type = type,
    )
}
