@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ConnectionMonitorIcmpConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes the ICMP configuration.
 * @property disableTraceRoute Value indicating whether path evaluation with trace route should be disabled.
 */
public data class ConnectionMonitorIcmpConfigurationArgs(
    public val disableTraceRoute: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.ConnectionMonitorIcmpConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.ConnectionMonitorIcmpConfigurationArgs =
        com.pulumi.azurenative.network.inputs.ConnectionMonitorIcmpConfigurationArgs.builder()
            .disableTraceRoute(disableTraceRoute?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectionMonitorIcmpConfigurationArgs].
 */
@PulumiTagMarker
public class ConnectionMonitorIcmpConfigurationArgsBuilder internal constructor() {
    private var disableTraceRoute: Output<Boolean>? = null

    /**
     * @param value Value indicating whether path evaluation with trace route should be disabled.
     */
    @JvmName("dubjjiisejvesola")
    public suspend fun disableTraceRoute(`value`: Output<Boolean>) {
        this.disableTraceRoute = value
    }

    /**
     * @param value Value indicating whether path evaluation with trace route should be disabled.
     */
    @JvmName("difpwyswhafaeimx")
    public suspend fun disableTraceRoute(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableTraceRoute = mapped
    }

    internal fun build(): ConnectionMonitorIcmpConfigurationArgs =
        ConnectionMonitorIcmpConfigurationArgs(
            disableTraceRoute = disableTraceRoute,
        )
}
