@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ConnectionMonitorSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes the source of connection monitor.
 * @property port The source port used by connection monitor.
 * @property resourceId The ID of the resource used as the source by connection monitor.
 */
public data class ConnectionMonitorSourceArgs(
    public val port: Output<Int>? = null,
    public val resourceId: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.ConnectionMonitorSourceArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.ConnectionMonitorSourceArgs =
        com.pulumi.azurenative.network.inputs.ConnectionMonitorSourceArgs.builder()
            .port(port?.applyValue({ args0 -> args0 }))
            .resourceId(resourceId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectionMonitorSourceArgs].
 */
@PulumiTagMarker
public class ConnectionMonitorSourceArgsBuilder internal constructor() {
    private var port: Output<Int>? = null

    private var resourceId: Output<String>? = null

    /**
     * @param value The source port used by connection monitor.
     */
    @JvmName("ujovabatvyyctfxa")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value The ID of the resource used as the source by connection monitor.
     */
    @JvmName("nbyqhtgknmaoaqpt")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value The source port used by connection monitor.
     */
    @JvmName("kahkffcfnuvhmohx")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value The ID of the resource used as the source by connection monitor.
     */
    @JvmName("xqhqgddchfkltapd")
    public suspend fun resourceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    internal fun build(): ConnectionMonitorSourceArgs = ConnectionMonitorSourceArgs(
        port = port,
        resourceId = resourceId ?: throw PulumiNullFieldException("resourceId"),
    )
}
