@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ContainerNetworkInterfaceConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Container network interface configuration child resource.
 * @property containerNetworkInterfaces A list of container network interfaces created from this container network interface configuration.
 * @property id Resource ID.
 * @property ipConfigurations A list of ip configurations of the container network interface configuration.
 * @property name The name of the resource. This name can be used to access the resource.
 */
public data class ContainerNetworkInterfaceConfigurationArgs(
    public val containerNetworkInterfaces: Output<List<SubResourceArgs>>? = null,
    public val id: Output<String>? = null,
    public val ipConfigurations: Output<List<IPConfigurationProfileArgs>>? = null,
    public val name: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.ContainerNetworkInterfaceConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.ContainerNetworkInterfaceConfigurationArgs =
        com.pulumi.azurenative.network.inputs.ContainerNetworkInterfaceConfigurationArgs.builder()
            .containerNetworkInterfaces(
                containerNetworkInterfaces?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .id(id?.applyValue({ args0 -> args0 }))
            .ipConfigurations(
                ipConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContainerNetworkInterfaceConfigurationArgs].
 */
@PulumiTagMarker
public class ContainerNetworkInterfaceConfigurationArgsBuilder internal constructor() {
    private var containerNetworkInterfaces: Output<List<SubResourceArgs>>? = null

    private var id: Output<String>? = null

    private var ipConfigurations: Output<List<IPConfigurationProfileArgs>>? = null

    private var name: Output<String>? = null

    /**
     * @param value A list of container network interfaces created from this container network interface configuration.
     */
    @JvmName("raiatenwtlqdkayr")
    public suspend fun containerNetworkInterfaces(`value`: Output<List<SubResourceArgs>>) {
        this.containerNetworkInterfaces = value
    }

    @JvmName("qaprvmtjvacriaqj")
    public suspend fun containerNetworkInterfaces(vararg values: Output<SubResourceArgs>) {
        this.containerNetworkInterfaces = Output.all(values.asList())
    }

    /**
     * @param values A list of container network interfaces created from this container network interface configuration.
     */
    @JvmName("tcomampcuwqhaaao")
    public suspend fun containerNetworkInterfaces(values: List<Output<SubResourceArgs>>) {
        this.containerNetworkInterfaces = Output.all(values)
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("yitjlwpipivjycsn")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value A list of ip configurations of the container network interface configuration.
     */
    @JvmName("kgqxglcvjugspjkr")
    public suspend fun ipConfigurations(`value`: Output<List<IPConfigurationProfileArgs>>) {
        this.ipConfigurations = value
    }

    @JvmName("pxukxcoljxrsxcqe")
    public suspend fun ipConfigurations(vararg values: Output<IPConfigurationProfileArgs>) {
        this.ipConfigurations = Output.all(values.asList())
    }

    /**
     * @param values A list of ip configurations of the container network interface configuration.
     */
    @JvmName("apdlrbyumxgbntfc")
    public suspend fun ipConfigurations(values: List<Output<IPConfigurationProfileArgs>>) {
        this.ipConfigurations = Output.all(values)
    }

    /**
     * @param value The name of the resource. This name can be used to access the resource.
     */
    @JvmName("jnhjyltuoqtqshus")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A list of container network interfaces created from this container network interface configuration.
     */
    @JvmName("cnpxylywtquxrurw")
    public suspend fun containerNetworkInterfaces(`value`: List<SubResourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerNetworkInterfaces = mapped
    }

    /**
     * @param argument A list of container network interfaces created from this container network interface configuration.
     */
    @JvmName("hilkesowwjergmnu")
    public suspend
    fun containerNetworkInterfaces(argument: List<suspend SubResourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.containerNetworkInterfaces = mapped
    }

    /**
     * @param argument A list of container network interfaces created from this container network interface configuration.
     */
    @JvmName("qeaaeruewjukbkge")
    public suspend fun containerNetworkInterfaces(
        vararg
        argument: suspend SubResourceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.containerNetworkInterfaces = mapped
    }

    /**
     * @param argument A list of container network interfaces created from this container network interface configuration.
     */
    @JvmName("vouhgjvvgubhenyo")
    public suspend
    fun containerNetworkInterfaces(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SubResourceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.containerNetworkInterfaces = mapped
    }

    /**
     * @param values A list of container network interfaces created from this container network interface configuration.
     */
    @JvmName("wtodcwfufwotvbyg")
    public suspend fun containerNetworkInterfaces(vararg values: SubResourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.containerNetworkInterfaces = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("mgndjjwhdvtgvkhr")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value A list of ip configurations of the container network interface configuration.
     */
    @JvmName("gxymyrkwihaokdmo")
    public suspend fun ipConfigurations(`value`: List<IPConfigurationProfileArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipConfigurations = mapped
    }

    /**
     * @param argument A list of ip configurations of the container network interface configuration.
     */
    @JvmName("ifdcbhvlbyitmqep")
    public suspend
    fun ipConfigurations(argument: List<suspend IPConfigurationProfileArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            IPConfigurationProfileArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ipConfigurations = mapped
    }

    /**
     * @param argument A list of ip configurations of the container network interface configuration.
     */
    @JvmName("fsgnsupjboqgmpiy")
    public suspend fun ipConfigurations(
        vararg
        argument: suspend IPConfigurationProfileArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            IPConfigurationProfileArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ipConfigurations = mapped
    }

    /**
     * @param argument A list of ip configurations of the container network interface configuration.
     */
    @JvmName("nymxaqlbigemhorm")
    public suspend
    fun ipConfigurations(argument: suspend IPConfigurationProfileArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(IPConfigurationProfileArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ipConfigurations = mapped
    }

    /**
     * @param values A list of ip configurations of the container network interface configuration.
     */
    @JvmName("lsoclxwydxmqxwvv")
    public suspend fun ipConfigurations(vararg values: IPConfigurationProfileArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipConfigurations = mapped
    }

    /**
     * @param value The name of the resource. This name can be used to access the resource.
     */
    @JvmName("ucmkbiheovekmyyo")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): ContainerNetworkInterfaceConfigurationArgs =
        ContainerNetworkInterfaceConfigurationArgs(
            containerNetworkInterfaces = containerNetworkInterfaces,
            id = id,
            ipConfigurations = ipConfigurations,
            name = name,
        )
}
