@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.CustomRuleArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.ActionType
import com.pulumi.azurenative.network.kotlin.enums.CustomRuleEnabledState
import com.pulumi.azurenative.network.kotlin.enums.RuleType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Defines contents of a web application rule
 * @property action Describes what action to be applied when rule matches.
 * @property enabledState Describes if the custom rule is in enabled or disabled state. Defaults to Enabled if not specified.
 * @property matchConditions List of match conditions.
 * @property name Describes the name of the rule.
 * @property priority Describes priority of the rule. Rules with a lower value will be evaluated before rules with a higher value.
 * @property rateLimitDurationInMinutes Time window for resetting the rate limit count. Default is 1 minute.
 * @property rateLimitThreshold Number of allowed requests per client within the time window.
 * @property ruleType Describes type of rule.
 */
public data class CustomRuleArgs(
    public val action: Output<Either<String, ActionType>>,
    public val enabledState: Output<Either<String, CustomRuleEnabledState>>? = null,
    public val matchConditions: Output<List<FrontDoorMatchConditionArgs>>,
    public val name: Output<String>? = null,
    public val priority: Output<Int>,
    public val rateLimitDurationInMinutes: Output<Int>? = null,
    public val rateLimitThreshold: Output<Int>? = null,
    public val ruleType: Output<Either<String, RuleType>>,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.CustomRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.CustomRuleArgs =
        com.pulumi.azurenative.network.inputs.CustomRuleArgs.builder()
            .action(
                action.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .enabledState(
                enabledState?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .matchConditions(
                matchConditions.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .priority(priority.applyValue({ args0 -> args0 }))
            .rateLimitDurationInMinutes(rateLimitDurationInMinutes?.applyValue({ args0 -> args0 }))
            .rateLimitThreshold(rateLimitThreshold?.applyValue({ args0 -> args0 }))
            .ruleType(
                ruleType.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [CustomRuleArgs].
 */
@PulumiTagMarker
public class CustomRuleArgsBuilder internal constructor() {
    private var action: Output<Either<String, ActionType>>? = null

    private var enabledState: Output<Either<String, CustomRuleEnabledState>>? = null

    private var matchConditions: Output<List<FrontDoorMatchConditionArgs>>? = null

    private var name: Output<String>? = null

    private var priority: Output<Int>? = null

    private var rateLimitDurationInMinutes: Output<Int>? = null

    private var rateLimitThreshold: Output<Int>? = null

    private var ruleType: Output<Either<String, RuleType>>? = null

    /**
     * @param value Describes what action to be applied when rule matches.
     */
    @JvmName("bnbvgvdbphbwormh")
    public suspend fun action(`value`: Output<Either<String, ActionType>>) {
        this.action = value
    }

    /**
     * @param value Describes if the custom rule is in enabled or disabled state. Defaults to Enabled if not specified.
     */
    @JvmName("yuaaukoimbpbvauo")
    public suspend fun enabledState(`value`: Output<Either<String, CustomRuleEnabledState>>) {
        this.enabledState = value
    }

    /**
     * @param value List of match conditions.
     */
    @JvmName("ejgxhivskfbvrpjp")
    public suspend fun matchConditions(`value`: Output<List<FrontDoorMatchConditionArgs>>) {
        this.matchConditions = value
    }

    @JvmName("pdhkevhllfbrphln")
    public suspend fun matchConditions(vararg values: Output<FrontDoorMatchConditionArgs>) {
        this.matchConditions = Output.all(values.asList())
    }

    /**
     * @param values List of match conditions.
     */
    @JvmName("nbhwdcbnskkitmej")
    public suspend fun matchConditions(values: List<Output<FrontDoorMatchConditionArgs>>) {
        this.matchConditions = Output.all(values)
    }

    /**
     * @param value Describes the name of the rule.
     */
    @JvmName("tryceqjpuicdyxqg")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Describes priority of the rule. Rules with a lower value will be evaluated before rules with a higher value.
     */
    @JvmName("blcvxpaeyxwdlmrc")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value Time window for resetting the rate limit count. Default is 1 minute.
     */
    @JvmName("bbsgdvurmjthgums")
    public suspend fun rateLimitDurationInMinutes(`value`: Output<Int>) {
        this.rateLimitDurationInMinutes = value
    }

    /**
     * @param value Number of allowed requests per client within the time window.
     */
    @JvmName("vciyqkanpguhfpck")
    public suspend fun rateLimitThreshold(`value`: Output<Int>) {
        this.rateLimitThreshold = value
    }

    /**
     * @param value Describes type of rule.
     */
    @JvmName("hbmdpsidpmelctyq")
    public suspend fun ruleType(`value`: Output<Either<String, RuleType>>) {
        this.ruleType = value
    }

    /**
     * @param value Describes what action to be applied when rule matches.
     */
    @JvmName("lqqltymflroowftq")
    public suspend fun action(`value`: Either<String, ActionType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value Describes what action to be applied when rule matches.
     */
    @JvmName("hykyekfyirttigcm")
    public fun action(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ActionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value Describes what action to be applied when rule matches.
     */
    @JvmName("qjlqvmewkgftcqbe")
    public fun action(`value`: ActionType) {
        val toBeMapped = Either.ofRight<String, ActionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value Describes if the custom rule is in enabled or disabled state. Defaults to Enabled if not specified.
     */
    @JvmName("shericlogdwiphot")
    public suspend fun enabledState(`value`: Either<String, CustomRuleEnabledState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabledState = mapped
    }

    /**
     * @param value Describes if the custom rule is in enabled or disabled state. Defaults to Enabled if not specified.
     */
    @JvmName("flpfswmqkknnivmk")
    public fun enabledState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, CustomRuleEnabledState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabledState = mapped
    }

    /**
     * @param value Describes if the custom rule is in enabled or disabled state. Defaults to Enabled if not specified.
     */
    @JvmName("kaocnddaametivao")
    public fun enabledState(`value`: CustomRuleEnabledState) {
        val toBeMapped = Either.ofRight<String, CustomRuleEnabledState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabledState = mapped
    }

    /**
     * @param value List of match conditions.
     */
    @JvmName("oilwysevjwhfhtrr")
    public suspend fun matchConditions(`value`: List<FrontDoorMatchConditionArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchConditions = mapped
    }

    /**
     * @param argument List of match conditions.
     */
    @JvmName("ggjiynnghicufqku")
    public suspend
    fun matchConditions(argument: List<suspend FrontDoorMatchConditionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FrontDoorMatchConditionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.matchConditions = mapped
    }

    /**
     * @param argument List of match conditions.
     */
    @JvmName("xyuxaoasnomthbnr")
    public suspend fun matchConditions(
        vararg
        argument: suspend FrontDoorMatchConditionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            FrontDoorMatchConditionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.matchConditions = mapped
    }

    /**
     * @param argument List of match conditions.
     */
    @JvmName("nxkdptfwpcvxxcxx")
    public suspend
    fun matchConditions(argument: suspend FrontDoorMatchConditionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            FrontDoorMatchConditionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.matchConditions = mapped
    }

    /**
     * @param values List of match conditions.
     */
    @JvmName("tdcutdcihgrcihxs")
    public suspend fun matchConditions(vararg values: FrontDoorMatchConditionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchConditions = mapped
    }

    /**
     * @param value Describes the name of the rule.
     */
    @JvmName("kglhivynyovqnbro")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Describes priority of the rule. Rules with a lower value will be evaluated before rules with a higher value.
     */
    @JvmName("lkwvvtnmvqbrhkuq")
    public suspend fun priority(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value Time window for resetting the rate limit count. Default is 1 minute.
     */
    @JvmName("noxvpdmssmqoisve")
    public suspend fun rateLimitDurationInMinutes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rateLimitDurationInMinutes = mapped
    }

    /**
     * @param value Number of allowed requests per client within the time window.
     */
    @JvmName("kirlggewxnlbhvle")
    public suspend fun rateLimitThreshold(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rateLimitThreshold = mapped
    }

    /**
     * @param value Describes type of rule.
     */
    @JvmName("odwhxfuscelolgmh")
    public suspend fun ruleType(`value`: Either<String, RuleType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleType = mapped
    }

    /**
     * @param value Describes type of rule.
     */
    @JvmName("eycsouauwcclbfni")
    public fun ruleType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RuleType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleType = mapped
    }

    /**
     * @param value Describes type of rule.
     */
    @JvmName("hpfudilgucovysgy")
    public fun ruleType(`value`: RuleType) {
        val toBeMapped = Either.ofRight<String, RuleType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleType = mapped
    }

    internal fun build(): CustomRuleArgs = CustomRuleArgs(
        action = action ?: throw PulumiNullFieldException("action"),
        enabledState = enabledState,
        matchConditions = matchConditions ?: throw PulumiNullFieldException("matchConditions"),
        name = name,
        priority = priority ?: throw PulumiNullFieldException("priority"),
        rateLimitDurationInMinutes = rateLimitDurationInMinutes,
        rateLimitThreshold = rateLimitThreshold,
        ruleType = ruleType ?: throw PulumiNullFieldException("ruleType"),
    )
}
