@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.DelegationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Details the service to which the subnet is delegated.
 * @property actions Describes the actions permitted to the service upon delegation
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property name The name of the resource that is unique within a subnet. This name can be used to access the resource.
 * @property serviceName The name of the service to whom the subnet should be delegated (e.g. Microsoft.Sql/servers).
 * @property type Resource type.
 */
public data class DelegationArgs(
    public val actions: Output<List<String>>? = null,
    public val etag: Output<String>? = null,
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
    public val serviceName: Output<String>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.DelegationArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.DelegationArgs =
        com.pulumi.azurenative.network.inputs.DelegationArgs.builder()
            .actions(actions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .etag(etag?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DelegationArgs].
 */
@PulumiTagMarker
public class DelegationArgsBuilder internal constructor() {
    private var actions: Output<List<String>>? = null

    private var etag: Output<String>? = null

    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var serviceName: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Describes the actions permitted to the service upon delegation
     */
    @JvmName("xddgpuevvwkejqgr")
    public suspend fun actions(`value`: Output<List<String>>) {
        this.actions = value
    }

    @JvmName("xjutvhtrwjugueix")
    public suspend fun actions(vararg values: Output<String>) {
        this.actions = Output.all(values.asList())
    }

    /**
     * @param values Describes the actions permitted to the service upon delegation
     */
    @JvmName("jreistmbdyvqdueh")
    public suspend fun actions(values: List<Output<String>>) {
        this.actions = Output.all(values)
    }

    /**
     * @param value A unique read-only string that changes whenever the resource is updated.
     */
    @JvmName("pgcqqkqbjuayysof")
    public suspend fun etag(`value`: Output<String>) {
        this.etag = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("rbstpvwrooddnyxe")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The name of the resource that is unique within a subnet. This name can be used to access the resource.
     */
    @JvmName("hqynvepnvmmidlmy")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the service to whom the subnet should be delegated (e.g. Microsoft.Sql/servers).
     */
    @JvmName("wvxubsfjuxbkyegc")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value Resource type.
     */
    @JvmName("pfyleugsdgyeneah")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Describes the actions permitted to the service upon delegation
     */
    @JvmName("nojudklraoxqlaxm")
    public suspend fun actions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actions = mapped
    }

    /**
     * @param values Describes the actions permitted to the service upon delegation
     */
    @JvmName("rngujexepokykdrw")
    public suspend fun actions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actions = mapped
    }

    /**
     * @param value A unique read-only string that changes whenever the resource is updated.
     */
    @JvmName("orjlusrknkmgkyqq")
    public suspend fun etag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.etag = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("xqiubpuuslntdicf")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The name of the resource that is unique within a subnet. This name can be used to access the resource.
     */
    @JvmName("cevcrpucofmcecmv")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the service to whom the subnet should be delegated (e.g. Microsoft.Sql/servers).
     */
    @JvmName("ufbplgnsjgexdiws")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value Resource type.
     */
    @JvmName("iowxjdkfocmcrksg")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): DelegationArgs = DelegationArgs(
        actions = actions,
        etag = etag,
        id = id,
        name = name,
        serviceName = serviceName,
        type = type,
    )
}
