@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.EndpointPropertiesSubnetsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Subnet first address, scope, and/or last address.
 * @property first First address in the subnet.
 * @property last Last address in the subnet.
 * @property scope Block size (number of leading bits in the subnet mask).
 */
public data class EndpointPropertiesSubnetsArgs(
    public val first: Output<String>? = null,
    public val last: Output<String>? = null,
    public val scope: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.EndpointPropertiesSubnetsArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.EndpointPropertiesSubnetsArgs =
        com.pulumi.azurenative.network.inputs.EndpointPropertiesSubnetsArgs.builder()
            .first(first?.applyValue({ args0 -> args0 }))
            .last(last?.applyValue({ args0 -> args0 }))
            .scope(scope?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EndpointPropertiesSubnetsArgs].
 */
@PulumiTagMarker
public class EndpointPropertiesSubnetsArgsBuilder internal constructor() {
    private var first: Output<String>? = null

    private var last: Output<String>? = null

    private var scope: Output<Int>? = null

    /**
     * @param value First address in the subnet.
     */
    @JvmName("tqmcuctpybgdomdj")
    public suspend fun first(`value`: Output<String>) {
        this.first = value
    }

    /**
     * @param value Last address in the subnet.
     */
    @JvmName("vwttfgblovstivos")
    public suspend fun last(`value`: Output<String>) {
        this.last = value
    }

    /**
     * @param value Block size (number of leading bits in the subnet mask).
     */
    @JvmName("txbtgleudvghndcr")
    public suspend fun scope(`value`: Output<Int>) {
        this.scope = value
    }

    /**
     * @param value First address in the subnet.
     */
    @JvmName("wvmkusbnophhniqg")
    public suspend fun first(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.first = mapped
    }

    /**
     * @param value Last address in the subnet.
     */
    @JvmName("rcbhkwjcqjqlfarf")
    public suspend fun last(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.last = mapped
    }

    /**
     * @param value Block size (number of leading bits in the subnet mask).
     */
    @JvmName("ixxpdpijfbtqtsko")
    public suspend fun scope(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    internal fun build(): EndpointPropertiesSubnetsArgs = EndpointPropertiesSubnetsArgs(
        first = first,
        last = last,
        scope = scope,
    )
}
