@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ExpressRouteCircuitSkuArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.ExpressRouteCircuitSkuFamily
import com.pulumi.azurenative.network.kotlin.enums.ExpressRouteCircuitSkuTier
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Contains SKU in an ExpressRouteCircuit.
 * @property family The family of the SKU.
 * @property name The name of the SKU.
 * @property tier The tier of the SKU.
 */
public data class ExpressRouteCircuitSkuArgs(
    public val family: Output<Either<String, ExpressRouteCircuitSkuFamily>>? = null,
    public val name: Output<String>? = null,
    public val tier: Output<Either<String, ExpressRouteCircuitSkuTier>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.ExpressRouteCircuitSkuArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.ExpressRouteCircuitSkuArgs =
        com.pulumi.azurenative.network.inputs.ExpressRouteCircuitSkuArgs.builder()
            .family(
                family?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .tier(
                tier?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ExpressRouteCircuitSkuArgs].
 */
@PulumiTagMarker
public class ExpressRouteCircuitSkuArgsBuilder internal constructor() {
    private var family: Output<Either<String, ExpressRouteCircuitSkuFamily>>? = null

    private var name: Output<String>? = null

    private var tier: Output<Either<String, ExpressRouteCircuitSkuTier>>? = null

    /**
     * @param value The family of the SKU.
     */
    @JvmName("ujkjnotoqsmsllfu")
    public suspend fun family(`value`: Output<Either<String, ExpressRouteCircuitSkuFamily>>) {
        this.family = value
    }

    /**
     * @param value The name of the SKU.
     */
    @JvmName("gybrwsneirppurhd")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The tier of the SKU.
     */
    @JvmName("tlnipeqacnlqrpyx")
    public suspend fun tier(`value`: Output<Either<String, ExpressRouteCircuitSkuTier>>) {
        this.tier = value
    }

    /**
     * @param value The family of the SKU.
     */
    @JvmName("xhkoiuseftkdcmvr")
    public suspend fun family(`value`: Either<String, ExpressRouteCircuitSkuFamily>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.family = mapped
    }

    /**
     * @param value The family of the SKU.
     */
    @JvmName("nkgutfkusplmcisa")
    public fun family(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ExpressRouteCircuitSkuFamily>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.family = mapped
    }

    /**
     * @param value The family of the SKU.
     */
    @JvmName("hghfrmbmhdavlnpf")
    public fun family(`value`: ExpressRouteCircuitSkuFamily) {
        val toBeMapped = Either.ofRight<String, ExpressRouteCircuitSkuFamily>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.family = mapped
    }

    /**
     * @param value The name of the SKU.
     */
    @JvmName("dugcyaodnhyhjxvu")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The tier of the SKU.
     */
    @JvmName("gkyufbiiarfbghlj")
    public suspend fun tier(`value`: Either<String, ExpressRouteCircuitSkuTier>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    /**
     * @param value The tier of the SKU.
     */
    @JvmName("hpbclttmyypegiqt")
    public fun tier(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ExpressRouteCircuitSkuTier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    /**
     * @param value The tier of the SKU.
     */
    @JvmName("pncrwtkfygamchfx")
    public fun tier(`value`: ExpressRouteCircuitSkuTier) {
        val toBeMapped = Either.ofRight<String, ExpressRouteCircuitSkuTier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    internal fun build(): ExpressRouteCircuitSkuArgs = ExpressRouteCircuitSkuArgs(
        family = family,
        name = name,
        tier = tier,
    )
}
