@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ExpressRouteGatewayPropertiesAutoScaleConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Configuration for auto scaling.
 * @property bounds Minimum and maximum number of scale units to deploy.
 */
public data class ExpressRouteGatewayPropertiesAutoScaleConfigurationArgs(
    public val bounds: Output<ExpressRouteGatewayPropertiesBoundsArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.ExpressRouteGatewayPropertiesAutoScaleConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.ExpressRouteGatewayPropertiesAutoScaleConfigurationArgs =
        com.pulumi.azurenative.network.inputs.ExpressRouteGatewayPropertiesAutoScaleConfigurationArgs.builder()
            .bounds(bounds?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ExpressRouteGatewayPropertiesAutoScaleConfigurationArgs].
 */
@PulumiTagMarker
public class ExpressRouteGatewayPropertiesAutoScaleConfigurationArgsBuilder internal constructor() {
    private var bounds: Output<ExpressRouteGatewayPropertiesBoundsArgs>? = null

    /**
     * @param value Minimum and maximum number of scale units to deploy.
     */
    @JvmName("foxtwuuoodxjduye")
    public suspend fun bounds(`value`: Output<ExpressRouteGatewayPropertiesBoundsArgs>) {
        this.bounds = value
    }

    /**
     * @param value Minimum and maximum number of scale units to deploy.
     */
    @JvmName("jfiwwpacdpuncsfn")
    public suspend fun bounds(`value`: ExpressRouteGatewayPropertiesBoundsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bounds = mapped
    }

    /**
     * @param argument Minimum and maximum number of scale units to deploy.
     */
    @JvmName("cwpuvomtrhrojavn")
    public suspend
    fun bounds(argument: suspend ExpressRouteGatewayPropertiesBoundsArgsBuilder.() -> Unit) {
        val toBeMapped = ExpressRouteGatewayPropertiesBoundsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.bounds = mapped
    }

    internal fun build(): ExpressRouteGatewayPropertiesAutoScaleConfigurationArgs =
        ExpressRouteGatewayPropertiesAutoScaleConfigurationArgs(
            bounds = bounds,
        )
}
