@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ExpressRouteLinkArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.ExpressRouteLinkAdminState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * ExpressRouteLink child resource definition.
 * @property adminState Administrative state of the physical port.
 * @property id Resource ID.
 * @property macSecConfig MacSec configuration.
 * @property name Name of child port resource that is unique among child port resources of the parent.
 */
public data class ExpressRouteLinkArgs(
    public val adminState: Output<Either<String, ExpressRouteLinkAdminState>>? = null,
    public val id: Output<String>? = null,
    public val macSecConfig: Output<ExpressRouteLinkMacSecConfigArgs>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.ExpressRouteLinkArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.ExpressRouteLinkArgs =
        com.pulumi.azurenative.network.inputs.ExpressRouteLinkArgs.builder()
            .adminState(
                adminState?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .id(id?.applyValue({ args0 -> args0 }))
            .macSecConfig(macSecConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ExpressRouteLinkArgs].
 */
@PulumiTagMarker
public class ExpressRouteLinkArgsBuilder internal constructor() {
    private var adminState: Output<Either<String, ExpressRouteLinkAdminState>>? = null

    private var id: Output<String>? = null

    private var macSecConfig: Output<ExpressRouteLinkMacSecConfigArgs>? = null

    private var name: Output<String>? = null

    /**
     * @param value Administrative state of the physical port.
     */
    @JvmName("yikksmljxfsckqhp")
    public suspend fun adminState(`value`: Output<Either<String, ExpressRouteLinkAdminState>>) {
        this.adminState = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("qswdggfenxjbpfcv")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value MacSec configuration.
     */
    @JvmName("rgkrplonhipywifq")
    public suspend fun macSecConfig(`value`: Output<ExpressRouteLinkMacSecConfigArgs>) {
        this.macSecConfig = value
    }

    /**
     * @param value Name of child port resource that is unique among child port resources of the parent.
     */
    @JvmName("ebqmnyjyasxovruk")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Administrative state of the physical port.
     */
    @JvmName("ydwwqaclpjkdacxj")
    public suspend fun adminState(`value`: Either<String, ExpressRouteLinkAdminState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adminState = mapped
    }

    /**
     * @param value Administrative state of the physical port.
     */
    @JvmName("yrfypojkpurvhqyv")
    public fun adminState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ExpressRouteLinkAdminState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.adminState = mapped
    }

    /**
     * @param value Administrative state of the physical port.
     */
    @JvmName("xxirtneokbcenwsa")
    public fun adminState(`value`: ExpressRouteLinkAdminState) {
        val toBeMapped = Either.ofRight<String, ExpressRouteLinkAdminState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.adminState = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("ebbqpbaniaahxesy")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value MacSec configuration.
     */
    @JvmName("kwtlysuelxmgpbpe")
    public suspend fun macSecConfig(`value`: ExpressRouteLinkMacSecConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.macSecConfig = mapped
    }

    /**
     * @param argument MacSec configuration.
     */
    @JvmName("tqvivdlsgojnlxmb")
    public suspend
    fun macSecConfig(argument: suspend ExpressRouteLinkMacSecConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ExpressRouteLinkMacSecConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.macSecConfig = mapped
    }

    /**
     * @param value Name of child port resource that is unique among child port resources of the parent.
     */
    @JvmName("rcclwasdtphebcon")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): ExpressRouteLinkArgs = ExpressRouteLinkArgs(
        adminState = adminState,
        id = id,
        macSecConfig = macSecConfig,
        name = name,
    )
}
