@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.FilterItems.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Will contain the filter name and values to operate on
 * @property field The name of the field we would like to filter
 * @property values List of values to filter the current field by
 */
public data class FilterItems(
    public val `field`: String? = null,
    public val values: List<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.FilterItems> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.FilterItems =
        com.pulumi.azurenative.network.inputs.FilterItems.builder()
            .`field`(`field`?.let({ args0 -> args0 }))
            .values(values?.let({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [FilterItems].
 */
@PulumiTagMarker
public class FilterItemsBuilder internal constructor() {
    private var `field`: String? = null

    private var values: List<String>? = null

    /**
     * @param value The name of the field we would like to filter
     */
    @JvmName("cbqobvqclmdggqff")
    public suspend fun `field`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.`field` = mapped
    }

    /**
     * @param value List of values to filter the current field by
     */
    @JvmName("mshvkrjosxpkvdxb")
    public suspend fun values(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.values = mapped
    }

    /**
     * @param values List of values to filter the current field by
     */
    @JvmName("csrmnrhuxqxwonew")
    public suspend fun values(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.values = mapped
    }

    internal fun build(): FilterItems = FilterItems(
        `field` = `field`,
        values = values,
    )
}
