@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.FirewallPolicyCertificateAuthorityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Trusted Root certificates properties for tls.
 * @property keyVaultSecretId Secret Id of (base-64 encoded unencrypted pfx) 'Secret' or 'Certificate' object stored in KeyVault.
 * @property name Name of the CA certificate.
 */
public data class FirewallPolicyCertificateAuthorityArgs(
    public val keyVaultSecretId: Output<String>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.FirewallPolicyCertificateAuthorityArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.FirewallPolicyCertificateAuthorityArgs =
        com.pulumi.azurenative.network.inputs.FirewallPolicyCertificateAuthorityArgs.builder()
            .keyVaultSecretId(keyVaultSecretId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FirewallPolicyCertificateAuthorityArgs].
 */
@PulumiTagMarker
public class FirewallPolicyCertificateAuthorityArgsBuilder internal constructor() {
    private var keyVaultSecretId: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value Secret Id of (base-64 encoded unencrypted pfx) 'Secret' or 'Certificate' object stored in KeyVault.
     */
    @JvmName("acqeixrvmavwmxur")
    public suspend fun keyVaultSecretId(`value`: Output<String>) {
        this.keyVaultSecretId = value
    }

    /**
     * @param value Name of the CA certificate.
     */
    @JvmName("avwpmmefhjcrhkuq")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Secret Id of (base-64 encoded unencrypted pfx) 'Secret' or 'Certificate' object stored in KeyVault.
     */
    @JvmName("pataphtqhsfeqmem")
    public suspend fun keyVaultSecretId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultSecretId = mapped
    }

    /**
     * @param value Name of the CA certificate.
     */
    @JvmName("iwpimrbdpgcgytby")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): FirewallPolicyCertificateAuthorityArgs =
        FirewallPolicyCertificateAuthorityArgs(
            keyVaultSecretId = keyVaultSecretId,
            name = name,
        )
}
