@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.FirewallPolicyHttpHeaderToInsertArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * name and value of HTTP/S header to insert
 * @property headerName Contains the name of the header
 * @property headerValue Contains the value of the header
 */
public data class FirewallPolicyHttpHeaderToInsertArgs(
    public val headerName: Output<String>? = null,
    public val headerValue: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.FirewallPolicyHttpHeaderToInsertArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.FirewallPolicyHttpHeaderToInsertArgs =
        com.pulumi.azurenative.network.inputs.FirewallPolicyHttpHeaderToInsertArgs.builder()
            .headerName(headerName?.applyValue({ args0 -> args0 }))
            .headerValue(headerValue?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FirewallPolicyHttpHeaderToInsertArgs].
 */
@PulumiTagMarker
public class FirewallPolicyHttpHeaderToInsertArgsBuilder internal constructor() {
    private var headerName: Output<String>? = null

    private var headerValue: Output<String>? = null

    /**
     * @param value Contains the name of the header
     */
    @JvmName("amawehxaxoqdmfvo")
    public suspend fun headerName(`value`: Output<String>) {
        this.headerName = value
    }

    /**
     * @param value Contains the value of the header
     */
    @JvmName("asnpvvquncyoxqau")
    public suspend fun headerValue(`value`: Output<String>) {
        this.headerValue = value
    }

    /**
     * @param value Contains the name of the header
     */
    @JvmName("vwpngagilikutcan")
    public suspend fun headerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.headerName = mapped
    }

    /**
     * @param value Contains the value of the header
     */
    @JvmName("guyuycupyauirxys")
    public suspend fun headerValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.headerValue = mapped
    }

    internal fun build(): FirewallPolicyHttpHeaderToInsertArgs = FirewallPolicyHttpHeaderToInsertArgs(
        headerName = headerName,
        headerValue = headerValue,
    )
}
