@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.FirewallPolicyIntrusionDetectionArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.FirewallPolicyIntrusionDetectionStateType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Configuration for intrusion detection mode and rules.
 * @property configuration Intrusion detection configuration properties.
 * @property mode Intrusion detection general state.
 */
public data class FirewallPolicyIntrusionDetectionArgs(
    public val configuration: Output<FirewallPolicyIntrusionDetectionConfigurationArgs>? = null,
    public val mode: Output<Either<String, FirewallPolicyIntrusionDetectionStateType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.FirewallPolicyIntrusionDetectionArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.FirewallPolicyIntrusionDetectionArgs =
        com.pulumi.azurenative.network.inputs.FirewallPolicyIntrusionDetectionArgs.builder()
            .configuration(configuration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .mode(
                mode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [FirewallPolicyIntrusionDetectionArgs].
 */
@PulumiTagMarker
public class FirewallPolicyIntrusionDetectionArgsBuilder internal constructor() {
    private var configuration: Output<FirewallPolicyIntrusionDetectionConfigurationArgs>? = null

    private var mode: Output<Either<String, FirewallPolicyIntrusionDetectionStateType>>? = null

    /**
     * @param value Intrusion detection configuration properties.
     */
    @JvmName("omrrflicjyhocdrd")
    public suspend
    fun configuration(`value`: Output<FirewallPolicyIntrusionDetectionConfigurationArgs>) {
        this.configuration = value
    }

    /**
     * @param value Intrusion detection general state.
     */
    @JvmName("ufaqhydchgvlcptw")
    public suspend
    fun mode(`value`: Output<Either<String, FirewallPolicyIntrusionDetectionStateType>>) {
        this.mode = value
    }

    /**
     * @param value Intrusion detection configuration properties.
     */
    @JvmName("oqlfvkugjjpswyog")
    public suspend fun configuration(`value`: FirewallPolicyIntrusionDetectionConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configuration = mapped
    }

    /**
     * @param argument Intrusion detection configuration properties.
     */
    @JvmName("cpbynfianemyervt")
    public suspend
    fun configuration(argument: suspend FirewallPolicyIntrusionDetectionConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = FirewallPolicyIntrusionDetectionConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.configuration = mapped
    }

    /**
     * @param value Intrusion detection general state.
     */
    @JvmName("ipmvsweevtfkigsb")
    public suspend fun mode(`value`: Either<String, FirewallPolicyIntrusionDetectionStateType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value Intrusion detection general state.
     */
    @JvmName("vgfmilkbprtweqfy")
    public fun mode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, FirewallPolicyIntrusionDetectionStateType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value Intrusion detection general state.
     */
    @JvmName("nrfewcnxxccficuw")
    public fun mode(`value`: FirewallPolicyIntrusionDetectionStateType) {
        val toBeMapped = Either.ofRight<String, FirewallPolicyIntrusionDetectionStateType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    internal fun build(): FirewallPolicyIntrusionDetectionArgs = FirewallPolicyIntrusionDetectionArgs(
        configuration = configuration,
        mode = mode,
    )
}
