@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.FirewallPolicyIntrusionDetectionBypassTrafficSpecificationsArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.FirewallPolicyIntrusionDetectionProtocol
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Intrusion detection bypass traffic specification.
 * @property description Description of the bypass traffic rule.
 * @property destinationAddresses List of destination IP addresses or ranges for this rule.
 * @property destinationIpGroups List of destination IpGroups for this rule.
 * @property destinationPorts List of destination ports or ranges.
 * @property name Name of the bypass traffic rule.
 * @property protocol The rule bypass protocol.
 * @property sourceAddresses List of source IP addresses or ranges for this rule.
 * @property sourceIpGroups List of source IpGroups for this rule.
 */
public data class FirewallPolicyIntrusionDetectionBypassTrafficSpecificationsArgs(
    public val description: Output<String>? = null,
    public val destinationAddresses: Output<List<String>>? = null,
    public val destinationIpGroups: Output<List<String>>? = null,
    public val destinationPorts: Output<List<String>>? = null,
    public val name: Output<String>? = null,
    public val protocol: Output<Either<String, FirewallPolicyIntrusionDetectionProtocol>>? = null,
    public val sourceAddresses: Output<List<String>>? = null,
    public val sourceIpGroups: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.FirewallPolicyIntrusionDetectionBypassTrafficSpecificationsArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.FirewallPolicyIntrusionDetectionBypassTrafficSpecificationsArgs =
        com.pulumi.azurenative.network.inputs.FirewallPolicyIntrusionDetectionBypassTrafficSpecificationsArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .destinationAddresses(destinationAddresses?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .destinationIpGroups(destinationIpGroups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .destinationPorts(destinationPorts?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .protocol(
                protocol?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .sourceAddresses(sourceAddresses?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .sourceIpGroups(sourceIpGroups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [FirewallPolicyIntrusionDetectionBypassTrafficSpecificationsArgs].
 */
@PulumiTagMarker
public class FirewallPolicyIntrusionDetectionBypassTrafficSpecificationsArgsBuilder internal
constructor() {
    private var description: Output<String>? = null

    private var destinationAddresses: Output<List<String>>? = null

    private var destinationIpGroups: Output<List<String>>? = null

    private var destinationPorts: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var protocol: Output<Either<String, FirewallPolicyIntrusionDetectionProtocol>>? = null

    private var sourceAddresses: Output<List<String>>? = null

    private var sourceIpGroups: Output<List<String>>? = null

    /**
     * @param value Description of the bypass traffic rule.
     */
    @JvmName("btvqphsvuidufkgr")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value List of destination IP addresses or ranges for this rule.
     */
    @JvmName("mqdbsukvawfkgnbx")
    public suspend fun destinationAddresses(`value`: Output<List<String>>) {
        this.destinationAddresses = value
    }

    @JvmName("lahlbqfkxcjthtkq")
    public suspend fun destinationAddresses(vararg values: Output<String>) {
        this.destinationAddresses = Output.all(values.asList())
    }

    /**
     * @param values List of destination IP addresses or ranges for this rule.
     */
    @JvmName("mhytrepmekewevja")
    public suspend fun destinationAddresses(values: List<Output<String>>) {
        this.destinationAddresses = Output.all(values)
    }

    /**
     * @param value List of destination IpGroups for this rule.
     */
    @JvmName("khbtmevsrajguvod")
    public suspend fun destinationIpGroups(`value`: Output<List<String>>) {
        this.destinationIpGroups = value
    }

    @JvmName("pesvkqpyrghcmunu")
    public suspend fun destinationIpGroups(vararg values: Output<String>) {
        this.destinationIpGroups = Output.all(values.asList())
    }

    /**
     * @param values List of destination IpGroups for this rule.
     */
    @JvmName("fduqybycdcpcvqwh")
    public suspend fun destinationIpGroups(values: List<Output<String>>) {
        this.destinationIpGroups = Output.all(values)
    }

    /**
     * @param value List of destination ports or ranges.
     */
    @JvmName("nluhjfprtkynqpfu")
    public suspend fun destinationPorts(`value`: Output<List<String>>) {
        this.destinationPorts = value
    }

    @JvmName("xmycnwtwijyhkehh")
    public suspend fun destinationPorts(vararg values: Output<String>) {
        this.destinationPorts = Output.all(values.asList())
    }

    /**
     * @param values List of destination ports or ranges.
     */
    @JvmName("thcbnycqxnxdcjaa")
    public suspend fun destinationPorts(values: List<Output<String>>) {
        this.destinationPorts = Output.all(values)
    }

    /**
     * @param value Name of the bypass traffic rule.
     */
    @JvmName("ulojfbyjtfmaunwu")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The rule bypass protocol.
     */
    @JvmName("hyuyfoamlejcqhiv")
    public suspend
    fun protocol(`value`: Output<Either<String, FirewallPolicyIntrusionDetectionProtocol>>) {
        this.protocol = value
    }

    /**
     * @param value List of source IP addresses or ranges for this rule.
     */
    @JvmName("hunesmqxxgpxgcde")
    public suspend fun sourceAddresses(`value`: Output<List<String>>) {
        this.sourceAddresses = value
    }

    @JvmName("awibvxvmecqfispp")
    public suspend fun sourceAddresses(vararg values: Output<String>) {
        this.sourceAddresses = Output.all(values.asList())
    }

    /**
     * @param values List of source IP addresses or ranges for this rule.
     */
    @JvmName("eiboeeyvxiooosow")
    public suspend fun sourceAddresses(values: List<Output<String>>) {
        this.sourceAddresses = Output.all(values)
    }

    /**
     * @param value List of source IpGroups for this rule.
     */
    @JvmName("rrjrlkcwclxgmmob")
    public suspend fun sourceIpGroups(`value`: Output<List<String>>) {
        this.sourceIpGroups = value
    }

    @JvmName("dljoaskubvkboadm")
    public suspend fun sourceIpGroups(vararg values: Output<String>) {
        this.sourceIpGroups = Output.all(values.asList())
    }

    /**
     * @param values List of source IpGroups for this rule.
     */
    @JvmName("qlqdtqprykxpaxrd")
    public suspend fun sourceIpGroups(values: List<Output<String>>) {
        this.sourceIpGroups = Output.all(values)
    }

    /**
     * @param value Description of the bypass traffic rule.
     */
    @JvmName("redbknpntkblceqg")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value List of destination IP addresses or ranges for this rule.
     */
    @JvmName("ljwqbbaqovrmesyf")
    public suspend fun destinationAddresses(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationAddresses = mapped
    }

    /**
     * @param values List of destination IP addresses or ranges for this rule.
     */
    @JvmName("bgxcjadnfjjbgrco")
    public suspend fun destinationAddresses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationAddresses = mapped
    }

    /**
     * @param value List of destination IpGroups for this rule.
     */
    @JvmName("imdmqkqvlgphbluo")
    public suspend fun destinationIpGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationIpGroups = mapped
    }

    /**
     * @param values List of destination IpGroups for this rule.
     */
    @JvmName("ujrjrigwvrbhyrdv")
    public suspend fun destinationIpGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationIpGroups = mapped
    }

    /**
     * @param value List of destination ports or ranges.
     */
    @JvmName("owltgybinoicsshl")
    public suspend fun destinationPorts(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationPorts = mapped
    }

    /**
     * @param values List of destination ports or ranges.
     */
    @JvmName("uvuafkljaduapeow")
    public suspend fun destinationPorts(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationPorts = mapped
    }

    /**
     * @param value Name of the bypass traffic rule.
     */
    @JvmName("ssmggaudadanisne")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The rule bypass protocol.
     */
    @JvmName("rcnlullgtufxqxui")
    public suspend fun protocol(`value`: Either<String, FirewallPolicyIntrusionDetectionProtocol>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value The rule bypass protocol.
     */
    @JvmName("vgbsgidfvasukffx")
    public fun protocol(`value`: String) {
        val toBeMapped = Either.ofLeft<String, FirewallPolicyIntrusionDetectionProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value The rule bypass protocol.
     */
    @JvmName("jpotmucpuftuhpjr")
    public fun protocol(`value`: FirewallPolicyIntrusionDetectionProtocol) {
        val toBeMapped = Either.ofRight<String, FirewallPolicyIntrusionDetectionProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value List of source IP addresses or ranges for this rule.
     */
    @JvmName("womkaipfvydsiesr")
    public suspend fun sourceAddresses(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceAddresses = mapped
    }

    /**
     * @param values List of source IP addresses or ranges for this rule.
     */
    @JvmName("ufxavlqvbrpneiya")
    public suspend fun sourceAddresses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceAddresses = mapped
    }

    /**
     * @param value List of source IpGroups for this rule.
     */
    @JvmName("vhxndskntimyeglh")
    public suspend fun sourceIpGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceIpGroups = mapped
    }

    /**
     * @param values List of source IpGroups for this rule.
     */
    @JvmName("utjbxjnwobfytlov")
    public suspend fun sourceIpGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceIpGroups = mapped
    }

    internal fun build(): FirewallPolicyIntrusionDetectionBypassTrafficSpecificationsArgs =
        FirewallPolicyIntrusionDetectionBypassTrafficSpecificationsArgs(
            description = description,
            destinationAddresses = destinationAddresses,
            destinationIpGroups = destinationIpGroups,
            destinationPorts = destinationPorts,
            name = name,
            protocol = protocol,
            sourceAddresses = sourceAddresses,
            sourceIpGroups = sourceIpGroups,
        )
}
