@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.FirewallPolicyIntrusionDetectionConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The operation for configuring intrusion detection.
 * @property bypassTrafficSettings List of rules for traffic to bypass.
 * @property privateRanges IDPS Private IP address ranges are used to identify traffic direction (i.e. inbound, outbound, etc.). By default, only ranges defined by IANA RFC 1918 are considered private IP addresses. To modify default ranges, specify your Private IP address ranges with this property
 * @property signatureOverrides List of specific signatures states.
 */
public data class FirewallPolicyIntrusionDetectionConfigurationArgs(
    public val bypassTrafficSettings:
    Output<List<FirewallPolicyIntrusionDetectionBypassTrafficSpecificationsArgs>>? = null,
    public val privateRanges: Output<List<String>>? = null,
    public val signatureOverrides:
    Output<List<FirewallPolicyIntrusionDetectionSignatureSpecificationArgs>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.FirewallPolicyIntrusionDetectionConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.FirewallPolicyIntrusionDetectionConfigurationArgs =
        com.pulumi.azurenative.network.inputs.FirewallPolicyIntrusionDetectionConfigurationArgs.builder()
            .bypassTrafficSettings(
                bypassTrafficSettings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .privateRanges(privateRanges?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .signatureOverrides(
                signatureOverrides?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [FirewallPolicyIntrusionDetectionConfigurationArgs].
 */
@PulumiTagMarker
public class FirewallPolicyIntrusionDetectionConfigurationArgsBuilder internal constructor() {
    private var bypassTrafficSettings:
        Output<List<FirewallPolicyIntrusionDetectionBypassTrafficSpecificationsArgs>>? = null

    private var privateRanges: Output<List<String>>? = null

    private var signatureOverrides:
        Output<List<FirewallPolicyIntrusionDetectionSignatureSpecificationArgs>>? = null

    /**
     * @param value List of rules for traffic to bypass.
     */
    @JvmName("iuynwtcjvukecgrh")
    public suspend
    fun bypassTrafficSettings(`value`: Output<List<FirewallPolicyIntrusionDetectionBypassTrafficSpecificationsArgs>>) {
        this.bypassTrafficSettings = value
    }

    @JvmName("ftqnaufhfiurfatx")
    public suspend fun bypassTrafficSettings(
        vararg
        values: Output<FirewallPolicyIntrusionDetectionBypassTrafficSpecificationsArgs>,
    ) {
        this.bypassTrafficSettings = Output.all(values.asList())
    }

    /**
     * @param values List of rules for traffic to bypass.
     */
    @JvmName("htoxetxujtunwpoc")
    public suspend
    fun bypassTrafficSettings(values: List<Output<FirewallPolicyIntrusionDetectionBypassTrafficSpecificationsArgs>>) {
        this.bypassTrafficSettings = Output.all(values)
    }

    /**
     * @param value IDPS Private IP address ranges are used to identify traffic direction (i.e. inbound, outbound, etc.). By default, only ranges defined by IANA RFC 1918 are considered private IP addresses. To modify default ranges, specify your Private IP address ranges with this property
     */
    @JvmName("dvekcsrcawcxxxsx")
    public suspend fun privateRanges(`value`: Output<List<String>>) {
        this.privateRanges = value
    }

    @JvmName("hcehcdqxyilgljjj")
    public suspend fun privateRanges(vararg values: Output<String>) {
        this.privateRanges = Output.all(values.asList())
    }

    /**
     * @param values IDPS Private IP address ranges are used to identify traffic direction (i.e. inbound, outbound, etc.). By default, only ranges defined by IANA RFC 1918 are considered private IP addresses. To modify default ranges, specify your Private IP address ranges with this property
     */
    @JvmName("nhuabvmnamtxwdhr")
    public suspend fun privateRanges(values: List<Output<String>>) {
        this.privateRanges = Output.all(values)
    }

    /**
     * @param value List of specific signatures states.
     */
    @JvmName("wottdtwrlskrjugh")
    public suspend
    fun signatureOverrides(`value`: Output<List<FirewallPolicyIntrusionDetectionSignatureSpecificationArgs>>) {
        this.signatureOverrides = value
    }

    @JvmName("ftehqojyegnstobb")
    public suspend fun signatureOverrides(
        vararg
        values: Output<FirewallPolicyIntrusionDetectionSignatureSpecificationArgs>,
    ) {
        this.signatureOverrides = Output.all(values.asList())
    }

    /**
     * @param values List of specific signatures states.
     */
    @JvmName("aswkgrgafvphdybv")
    public suspend
    fun signatureOverrides(values: List<Output<FirewallPolicyIntrusionDetectionSignatureSpecificationArgs>>) {
        this.signatureOverrides = Output.all(values)
    }

    /**
     * @param value List of rules for traffic to bypass.
     */
    @JvmName("ysjppbiivnhackqr")
    public suspend
    fun bypassTrafficSettings(`value`: List<FirewallPolicyIntrusionDetectionBypassTrafficSpecificationsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bypassTrafficSettings = mapped
    }

    /**
     * @param argument List of rules for traffic to bypass.
     */
    @JvmName("skbmpblnfmmnqxps")
    public suspend
    fun bypassTrafficSettings(argument: List<suspend FirewallPolicyIntrusionDetectionBypassTrafficSpecificationsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FirewallPolicyIntrusionDetectionBypassTrafficSpecificationsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.bypassTrafficSettings = mapped
    }

    /**
     * @param argument List of rules for traffic to bypass.
     */
    @JvmName("erkyyacwtcqyvthb")
    public suspend fun bypassTrafficSettings(
        vararg
        argument: suspend FirewallPolicyIntrusionDetectionBypassTrafficSpecificationsArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            FirewallPolicyIntrusionDetectionBypassTrafficSpecificationsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.bypassTrafficSettings = mapped
    }

    /**
     * @param argument List of rules for traffic to bypass.
     */
    @JvmName("xqpqbksbafdoynra")
    public suspend
    fun bypassTrafficSettings(argument: suspend FirewallPolicyIntrusionDetectionBypassTrafficSpecificationsArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                FirewallPolicyIntrusionDetectionBypassTrafficSpecificationsArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.bypassTrafficSettings = mapped
    }

    /**
     * @param values List of rules for traffic to bypass.
     */
    @JvmName("phfwftnpebtaawdn")
    public suspend fun bypassTrafficSettings(
        vararg
        values: FirewallPolicyIntrusionDetectionBypassTrafficSpecificationsArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bypassTrafficSettings = mapped
    }

    /**
     * @param value IDPS Private IP address ranges are used to identify traffic direction (i.e. inbound, outbound, etc.). By default, only ranges defined by IANA RFC 1918 are considered private IP addresses. To modify default ranges, specify your Private IP address ranges with this property
     */
    @JvmName("dlnfrvcexjeuyiwb")
    public suspend fun privateRanges(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateRanges = mapped
    }

    /**
     * @param values IDPS Private IP address ranges are used to identify traffic direction (i.e. inbound, outbound, etc.). By default, only ranges defined by IANA RFC 1918 are considered private IP addresses. To modify default ranges, specify your Private IP address ranges with this property
     */
    @JvmName("kvgiyikxxllvnyop")
    public suspend fun privateRanges(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateRanges = mapped
    }

    /**
     * @param value List of specific signatures states.
     */
    @JvmName("qqarpwhikcqecfxo")
    public suspend
    fun signatureOverrides(`value`: List<FirewallPolicyIntrusionDetectionSignatureSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.signatureOverrides = mapped
    }

    /**
     * @param argument List of specific signatures states.
     */
    @JvmName("wkormfevidjlgvhw")
    public suspend
    fun signatureOverrides(argument: List<suspend FirewallPolicyIntrusionDetectionSignatureSpecificationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FirewallPolicyIntrusionDetectionSignatureSpecificationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.signatureOverrides = mapped
    }

    /**
     * @param argument List of specific signatures states.
     */
    @JvmName("hufbsstlqqjcdnod")
    public suspend fun signatureOverrides(
        vararg
        argument: suspend FirewallPolicyIntrusionDetectionSignatureSpecificationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            FirewallPolicyIntrusionDetectionSignatureSpecificationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.signatureOverrides = mapped
    }

    /**
     * @param argument List of specific signatures states.
     */
    @JvmName("syiknuwtlkywnmye")
    public suspend
    fun signatureOverrides(argument: suspend FirewallPolicyIntrusionDetectionSignatureSpecificationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                FirewallPolicyIntrusionDetectionSignatureSpecificationArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.signatureOverrides = mapped
    }

    /**
     * @param values List of specific signatures states.
     */
    @JvmName("pfjbndwxxxdscfmc")
    public suspend fun signatureOverrides(
        vararg
        values: FirewallPolicyIntrusionDetectionSignatureSpecificationArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.signatureOverrides = mapped
    }

    internal fun build(): FirewallPolicyIntrusionDetectionConfigurationArgs =
        FirewallPolicyIntrusionDetectionConfigurationArgs(
            bypassTrafficSettings = bypassTrafficSettings,
            privateRanges = privateRanges,
            signatureOverrides = signatureOverrides,
        )
}
