@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.FirewallPolicyLogAnalyticsWorkspaceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Log Analytics Workspace for Firewall Policy Insights.
 * @property region Region to configure the Workspace.
 * @property workspaceId The workspace Id for Firewall Policy Insights.
 */
public data class FirewallPolicyLogAnalyticsWorkspaceArgs(
    public val region: Output<String>? = null,
    public val workspaceId: Output<SubResourceArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.FirewallPolicyLogAnalyticsWorkspaceArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.FirewallPolicyLogAnalyticsWorkspaceArgs =
        com.pulumi.azurenative.network.inputs.FirewallPolicyLogAnalyticsWorkspaceArgs.builder()
            .region(region?.applyValue({ args0 -> args0 }))
            .workspaceId(workspaceId?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [FirewallPolicyLogAnalyticsWorkspaceArgs].
 */
@PulumiTagMarker
public class FirewallPolicyLogAnalyticsWorkspaceArgsBuilder internal constructor() {
    private var region: Output<String>? = null

    private var workspaceId: Output<SubResourceArgs>? = null

    /**
     * @param value Region to configure the Workspace.
     */
    @JvmName("ohpngfoftvuoecdo")
    public suspend fun region(`value`: Output<String>) {
        this.region = value
    }

    /**
     * @param value The workspace Id for Firewall Policy Insights.
     */
    @JvmName("tqnyeplrsvrjswhv")
    public suspend fun workspaceId(`value`: Output<SubResourceArgs>) {
        this.workspaceId = value
    }

    /**
     * @param value Region to configure the Workspace.
     */
    @JvmName("swaunhkjdciuarvv")
    public suspend fun region(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.region = mapped
    }

    /**
     * @param value The workspace Id for Firewall Policy Insights.
     */
    @JvmName("excrfcswjybnkmjj")
    public suspend fun workspaceId(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceId = mapped
    }

    /**
     * @param argument The workspace Id for Firewall Policy Insights.
     */
    @JvmName("cqgjkxkepmtcbnwx")
    public suspend fun workspaceId(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.workspaceId = mapped
    }

    internal fun build(): FirewallPolicyLogAnalyticsWorkspaceArgs =
        FirewallPolicyLogAnalyticsWorkspaceArgs(
            region = region,
            workspaceId = workspaceId,
        )
}
