@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.FirewallPolicyRuleApplicationProtocolArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.FirewallPolicyRuleApplicationProtocolType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Properties of the application rule protocol.
 * @property port Port number for the protocol, cannot be greater than 64000.
 * @property protocolType Protocol type.
 */
public data class FirewallPolicyRuleApplicationProtocolArgs(
    public val port: Output<Int>? = null,
    public val protocolType: Output<Either<String, FirewallPolicyRuleApplicationProtocolType>>? =
        null,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.FirewallPolicyRuleApplicationProtocolArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.FirewallPolicyRuleApplicationProtocolArgs =
        com.pulumi.azurenative.network.inputs.FirewallPolicyRuleApplicationProtocolArgs.builder()
            .port(port?.applyValue({ args0 -> args0 }))
            .protocolType(
                protocolType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [FirewallPolicyRuleApplicationProtocolArgs].
 */
@PulumiTagMarker
public class FirewallPolicyRuleApplicationProtocolArgsBuilder internal constructor() {
    private var port: Output<Int>? = null

    private var protocolType: Output<Either<String, FirewallPolicyRuleApplicationProtocolType>>? =
        null

    /**
     * @param value Port number for the protocol, cannot be greater than 64000.
     */
    @JvmName("ccttuxnqluquvuea")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value Protocol type.
     */
    @JvmName("fnjhancadxcdcnmh")
    public suspend
    fun protocolType(`value`: Output<Either<String, FirewallPolicyRuleApplicationProtocolType>>) {
        this.protocolType = value
    }

    /**
     * @param value Port number for the protocol, cannot be greater than 64000.
     */
    @JvmName("nxqtbleldobmmswi")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value Protocol type.
     */
    @JvmName("ipnoyxfjunowhles")
    public suspend
    fun protocolType(`value`: Either<String, FirewallPolicyRuleApplicationProtocolType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocolType = mapped
    }

    /**
     * @param value Protocol type.
     */
    @JvmName("ddlsfsyjmyqxpvid")
    public fun protocolType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, FirewallPolicyRuleApplicationProtocolType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocolType = mapped
    }

    /**
     * @param value Protocol type.
     */
    @JvmName("nkilsokmlrjshqjb")
    public fun protocolType(`value`: FirewallPolicyRuleApplicationProtocolType) {
        val toBeMapped = Either.ofRight<String, FirewallPolicyRuleApplicationProtocolType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocolType = mapped
    }

    internal fun build(): FirewallPolicyRuleApplicationProtocolArgs =
        FirewallPolicyRuleApplicationProtocolArgs(
            port = port,
            protocolType = protocolType,
        )
}
