@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.FirewallPolicyRuleConditionApplicationProtocolArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.FirewallPolicyRuleConditionApplicationProtocolType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Properties of the application rule protocol.
 * @property port Port number for the protocol, cannot be greater than 64000.
 * @property protocolType Protocol type.
 */
public data class FirewallPolicyRuleConditionApplicationProtocolArgs(
    public val port: Output<Int>? = null,
    public val protocolType:
    Output<Either<String, FirewallPolicyRuleConditionApplicationProtocolType>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.FirewallPolicyRuleConditionApplicationProtocolArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.FirewallPolicyRuleConditionApplicationProtocolArgs =
        com.pulumi.azurenative.network.inputs.FirewallPolicyRuleConditionApplicationProtocolArgs.builder()
            .port(port?.applyValue({ args0 -> args0 }))
            .protocolType(
                protocolType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [FirewallPolicyRuleConditionApplicationProtocolArgs].
 */
@PulumiTagMarker
public class FirewallPolicyRuleConditionApplicationProtocolArgsBuilder internal constructor() {
    private var port: Output<Int>? = null

    private var protocolType:
        Output<Either<String, FirewallPolicyRuleConditionApplicationProtocolType>>? = null

    /**
     * @param value Port number for the protocol, cannot be greater than 64000.
     */
    @JvmName("smliayfbtdvtmdji")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value Protocol type.
     */
    @JvmName("iriggswwpatbomli")
    public suspend
    fun protocolType(`value`: Output<Either<String, FirewallPolicyRuleConditionApplicationProtocolType>>) {
        this.protocolType = value
    }

    /**
     * @param value Port number for the protocol, cannot be greater than 64000.
     */
    @JvmName("cnmnnthxcvrlwqfe")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value Protocol type.
     */
    @JvmName("qaoplyekigphwqdl")
    public suspend
    fun protocolType(`value`: Either<String, FirewallPolicyRuleConditionApplicationProtocolType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocolType = mapped
    }

    /**
     * @param value Protocol type.
     */
    @JvmName("qjafeeumxcnmhnux")
    public fun protocolType(`value`: String) {
        val toBeMapped = Either.ofLeft<String,
            FirewallPolicyRuleConditionApplicationProtocolType,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocolType = mapped
    }

    /**
     * @param value Protocol type.
     */
    @JvmName("qkpjvrdpdsxpqqty")
    public fun protocolType(`value`: FirewallPolicyRuleConditionApplicationProtocolType) {
        val toBeMapped = Either.ofRight<String,
            FirewallPolicyRuleConditionApplicationProtocolType,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocolType = mapped
    }

    internal fun build(): FirewallPolicyRuleConditionApplicationProtocolArgs =
        FirewallPolicyRuleConditionApplicationProtocolArgs(
            port = port,
            protocolType = protocolType,
        )
}
