@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.FirewallPolicySNATArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.AutoLearnPrivateRangesMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The private IP addresses/IP ranges to which traffic will not be SNAT.
 * @property autoLearnPrivateRanges The operation mode for automatically learning private ranges to not be SNAT
 * @property privateRanges List of private IP addresses/IP address ranges to not be SNAT.
 */
public data class FirewallPolicySNATArgs(
    public val autoLearnPrivateRanges: Output<Either<String, AutoLearnPrivateRangesMode>>? = null,
    public val privateRanges: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.FirewallPolicySNATArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.FirewallPolicySNATArgs =
        com.pulumi.azurenative.network.inputs.FirewallPolicySNATArgs.builder()
            .autoLearnPrivateRanges(
                autoLearnPrivateRanges?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .privateRanges(privateRanges?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [FirewallPolicySNATArgs].
 */
@PulumiTagMarker
public class FirewallPolicySNATArgsBuilder internal constructor() {
    private var autoLearnPrivateRanges: Output<Either<String, AutoLearnPrivateRangesMode>>? = null

    private var privateRanges: Output<List<String>>? = null

    /**
     * @param value The operation mode for automatically learning private ranges to not be SNAT
     */
    @JvmName("bkhhisxlmjqiwuum")
    public suspend
    fun autoLearnPrivateRanges(`value`: Output<Either<String, AutoLearnPrivateRangesMode>>) {
        this.autoLearnPrivateRanges = value
    }

    /**
     * @param value List of private IP addresses/IP address ranges to not be SNAT.
     */
    @JvmName("jkvcsmcekbectfpy")
    public suspend fun privateRanges(`value`: Output<List<String>>) {
        this.privateRanges = value
    }

    @JvmName("weyjlergafsflkcc")
    public suspend fun privateRanges(vararg values: Output<String>) {
        this.privateRanges = Output.all(values.asList())
    }

    /**
     * @param values List of private IP addresses/IP address ranges to not be SNAT.
     */
    @JvmName("jaycfsydnsdbxouq")
    public suspend fun privateRanges(values: List<Output<String>>) {
        this.privateRanges = Output.all(values)
    }

    /**
     * @param value The operation mode for automatically learning private ranges to not be SNAT
     */
    @JvmName("qhkmlcbixfosggyt")
    public suspend fun autoLearnPrivateRanges(`value`: Either<String, AutoLearnPrivateRangesMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoLearnPrivateRanges = mapped
    }

    /**
     * @param value The operation mode for automatically learning private ranges to not be SNAT
     */
    @JvmName("ojnrcwdbemdlwjpa")
    public fun autoLearnPrivateRanges(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AutoLearnPrivateRangesMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.autoLearnPrivateRanges = mapped
    }

    /**
     * @param value The operation mode for automatically learning private ranges to not be SNAT
     */
    @JvmName("godwrcahkpiajspc")
    public fun autoLearnPrivateRanges(`value`: AutoLearnPrivateRangesMode) {
        val toBeMapped = Either.ofRight<String, AutoLearnPrivateRangesMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.autoLearnPrivateRanges = mapped
    }

    /**
     * @param value List of private IP addresses/IP address ranges to not be SNAT.
     */
    @JvmName("afpcydyvntgqxolf")
    public suspend fun privateRanges(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateRanges = mapped
    }

    /**
     * @param values List of private IP addresses/IP address ranges to not be SNAT.
     */
    @JvmName("corcdkjhbhhgqttw")
    public suspend fun privateRanges(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateRanges = mapped
    }

    internal fun build(): FirewallPolicySNATArgs = FirewallPolicySNATArgs(
        autoLearnPrivateRanges = autoLearnPrivateRanges,
        privateRanges = privateRanges,
    )
}
