@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.FirewallPolicyThreatIntelWhitelistArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * ThreatIntel Whitelist for Firewall Policy.
 * @property fqdns List of FQDNs for the ThreatIntel Whitelist.
 * @property ipAddresses List of IP addresses for the ThreatIntel Whitelist.
 */
public data class FirewallPolicyThreatIntelWhitelistArgs(
    public val fqdns: Output<List<String>>? = null,
    public val ipAddresses: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.FirewallPolicyThreatIntelWhitelistArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.FirewallPolicyThreatIntelWhitelistArgs =
        com.pulumi.azurenative.network.inputs.FirewallPolicyThreatIntelWhitelistArgs.builder()
            .fqdns(fqdns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .ipAddresses(ipAddresses?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [FirewallPolicyThreatIntelWhitelistArgs].
 */
@PulumiTagMarker
public class FirewallPolicyThreatIntelWhitelistArgsBuilder internal constructor() {
    private var fqdns: Output<List<String>>? = null

    private var ipAddresses: Output<List<String>>? = null

    /**
     * @param value List of FQDNs for the ThreatIntel Whitelist.
     */
    @JvmName("coksjkhvfkoeadls")
    public suspend fun fqdns(`value`: Output<List<String>>) {
        this.fqdns = value
    }

    @JvmName("ffdibgbdgbwmdgqn")
    public suspend fun fqdns(vararg values: Output<String>) {
        this.fqdns = Output.all(values.asList())
    }

    /**
     * @param values List of FQDNs for the ThreatIntel Whitelist.
     */
    @JvmName("vormqgntgxdcrljf")
    public suspend fun fqdns(values: List<Output<String>>) {
        this.fqdns = Output.all(values)
    }

    /**
     * @param value List of IP addresses for the ThreatIntel Whitelist.
     */
    @JvmName("txekjnkqcljyvlmw")
    public suspend fun ipAddresses(`value`: Output<List<String>>) {
        this.ipAddresses = value
    }

    @JvmName("osbryvmgbsfkwrnu")
    public suspend fun ipAddresses(vararg values: Output<String>) {
        this.ipAddresses = Output.all(values.asList())
    }

    /**
     * @param values List of IP addresses for the ThreatIntel Whitelist.
     */
    @JvmName("uruupkqgtqshmmkb")
    public suspend fun ipAddresses(values: List<Output<String>>) {
        this.ipAddresses = Output.all(values)
    }

    /**
     * @param value List of FQDNs for the ThreatIntel Whitelist.
     */
    @JvmName("leruerbjbequhtmw")
    public suspend fun fqdns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fqdns = mapped
    }

    /**
     * @param values List of FQDNs for the ThreatIntel Whitelist.
     */
    @JvmName("envtjhjjkbgpwnvq")
    public suspend fun fqdns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fqdns = mapped
    }

    /**
     * @param value List of IP addresses for the ThreatIntel Whitelist.
     */
    @JvmName("txoajuqijwixhewo")
    public suspend fun ipAddresses(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipAddresses = mapped
    }

    /**
     * @param values List of IP addresses for the ThreatIntel Whitelist.
     */
    @JvmName("hkatuwkdrqdgjkva")
    public suspend fun ipAddresses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipAddresses = mapped
    }

    internal fun build(): FirewallPolicyThreatIntelWhitelistArgs =
        FirewallPolicyThreatIntelWhitelistArgs(
            fqdns = fqdns,
            ipAddresses = ipAddresses,
        )
}
