@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.FrontendEndpointArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.SessionAffinityEnabledState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * A frontend endpoint used for routing.
 * @property hostName The host name of the frontendEndpoint. Must be a domain name.
 * @property id Resource ID.
 * @property name Resource name.
 * @property sessionAffinityEnabledState Whether to allow session affinity on this host. Valid options are 'Enabled' or 'Disabled'
 * @property sessionAffinityTtlSeconds UNUSED. This field will be ignored. The TTL to use in seconds for session affinity, if applicable.
 * @property webApplicationFirewallPolicyLink Defines the Web Application Firewall policy for each host (if applicable)
 */
public data class FrontendEndpointArgs(
    public val hostName: Output<String>? = null,
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
    public val sessionAffinityEnabledState: Output<Either<String, SessionAffinityEnabledState>>? =
        null,
    public val sessionAffinityTtlSeconds: Output<Int>? = null,
    public val webApplicationFirewallPolicyLink:
    Output<FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLinkArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.FrontendEndpointArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.FrontendEndpointArgs =
        com.pulumi.azurenative.network.inputs.FrontendEndpointArgs.builder()
            .hostName(hostName?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .sessionAffinityEnabledState(
                sessionAffinityEnabledState?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .sessionAffinityTtlSeconds(sessionAffinityTtlSeconds?.applyValue({ args0 -> args0 }))
            .webApplicationFirewallPolicyLink(
                webApplicationFirewallPolicyLink?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            ).build()
}

/**
 * Builder for [FrontendEndpointArgs].
 */
@PulumiTagMarker
public class FrontendEndpointArgsBuilder internal constructor() {
    private var hostName: Output<String>? = null

    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var sessionAffinityEnabledState: Output<Either<String, SessionAffinityEnabledState>>? =
        null

    private var sessionAffinityTtlSeconds: Output<Int>? = null

    private var webApplicationFirewallPolicyLink:
        Output<FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLinkArgs>? = null

    /**
     * @param value The host name of the frontendEndpoint. Must be a domain name.
     */
    @JvmName("knkhglnjdxwmhgmy")
    public suspend fun hostName(`value`: Output<String>) {
        this.hostName = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("ijjhvhdytgkerqvx")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Resource name.
     */
    @JvmName("xgspimbpgdrtnicx")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Whether to allow session affinity on this host. Valid options are 'Enabled' or 'Disabled'
     */
    @JvmName("htruwfpwwqgigrqb")
    public suspend
    fun sessionAffinityEnabledState(`value`: Output<Either<String, SessionAffinityEnabledState>>) {
        this.sessionAffinityEnabledState = value
    }

    /**
     * @param value UNUSED. This field will be ignored. The TTL to use in seconds for session affinity, if applicable.
     */
    @JvmName("jthvqcleccrclbpm")
    public suspend fun sessionAffinityTtlSeconds(`value`: Output<Int>) {
        this.sessionAffinityTtlSeconds = value
    }

    /**
     * @param value Defines the Web Application Firewall policy for each host (if applicable)
     */
    @JvmName("jvmvugvdbmgwecvy")
    public suspend
    fun webApplicationFirewallPolicyLink(`value`: Output<FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLinkArgs>) {
        this.webApplicationFirewallPolicyLink = value
    }

    /**
     * @param value The host name of the frontendEndpoint. Must be a domain name.
     */
    @JvmName("etynylojjtdsiaps")
    public suspend fun hostName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostName = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("uotejvdomlbhbrtj")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Resource name.
     */
    @JvmName("vxicfnrjkgyjybuw")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Whether to allow session affinity on this host. Valid options are 'Enabled' or 'Disabled'
     */
    @JvmName("betpmwawjocvydsv")
    public suspend
    fun sessionAffinityEnabledState(`value`: Either<String, SessionAffinityEnabledState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sessionAffinityEnabledState = mapped
    }

    /**
     * @param value Whether to allow session affinity on this host. Valid options are 'Enabled' or 'Disabled'
     */
    @JvmName("kyjtuijepaykaitj")
    public fun sessionAffinityEnabledState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SessionAffinityEnabledState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sessionAffinityEnabledState = mapped
    }

    /**
     * @param value Whether to allow session affinity on this host. Valid options are 'Enabled' or 'Disabled'
     */
    @JvmName("fmypwxvkfhcfevmu")
    public fun sessionAffinityEnabledState(`value`: SessionAffinityEnabledState) {
        val toBeMapped = Either.ofRight<String, SessionAffinityEnabledState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sessionAffinityEnabledState = mapped
    }

    /**
     * @param value UNUSED. This field will be ignored. The TTL to use in seconds for session affinity, if applicable.
     */
    @JvmName("cnyydmmxbgkpbsrn")
    public suspend fun sessionAffinityTtlSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sessionAffinityTtlSeconds = mapped
    }

    /**
     * @param value Defines the Web Application Firewall policy for each host (if applicable)
     */
    @JvmName("eigfxrldtykqwgfv")
    public suspend
    fun webApplicationFirewallPolicyLink(`value`: FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLinkArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.webApplicationFirewallPolicyLink = mapped
    }

    /**
     * @param argument Defines the Web Application Firewall policy for each host (if applicable)
     */
    @JvmName("gwurbhwxsuklemam")
    public suspend
    fun webApplicationFirewallPolicyLink(argument: suspend FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLinkArgsBuilder.() -> Unit) {
        val toBeMapped =
            FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLinkArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.webApplicationFirewallPolicyLink = mapped
    }

    internal fun build(): FrontendEndpointArgs = FrontendEndpointArgs(
        hostName = hostName,
        id = id,
        name = name,
        sessionAffinityEnabledState = sessionAffinityEnabledState,
        sessionAffinityTtlSeconds = sessionAffinityTtlSeconds,
        webApplicationFirewallPolicyLink = webApplicationFirewallPolicyLink,
    )
}
