@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLinkArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Defines the Web Application Firewall policy for each host (if applicable)
 * @property id Resource ID.
 */
public data class FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLinkArgs(
    public val id: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLinkArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLinkArgs =
        com.pulumi.azurenative.network.inputs.FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLinkArgs.builder()
            .id(id?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLinkArgs].
 */
@PulumiTagMarker
public class FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLinkArgsBuilder internal
constructor() {
    private var id: Output<String>? = null

    /**
     * @param value Resource ID.
     */
    @JvmName("vbxyrgxohtvxbpbe")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("hvniepvocsftutfv")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLinkArgs =
        FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLinkArgs(
            id = id,
        )
}
