@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GatewayLoadBalancerTunnelInterfaceArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.GatewayLoadBalancerTunnelInterfaceType
import com.pulumi.azurenative.network.kotlin.enums.GatewayLoadBalancerTunnelProtocol
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Gateway load balancer tunnel interface of a load balancer backend address pool.
 * @property identifier Identifier of gateway load balancer tunnel interface.
 * @property port Port of gateway load balancer tunnel interface.
 * @property protocol Protocol of gateway load balancer tunnel interface.
 * @property type Traffic type of gateway load balancer tunnel interface.
 */
public data class GatewayLoadBalancerTunnelInterfaceArgs(
    public val identifier: Output<Int>? = null,
    public val port: Output<Int>? = null,
    public val protocol: Output<Either<String, GatewayLoadBalancerTunnelProtocol>>? = null,
    public val type: Output<Either<String, GatewayLoadBalancerTunnelInterfaceType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GatewayLoadBalancerTunnelInterfaceArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.GatewayLoadBalancerTunnelInterfaceArgs =
        com.pulumi.azurenative.network.inputs.GatewayLoadBalancerTunnelInterfaceArgs.builder()
            .identifier(identifier?.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 }))
            .protocol(
                protocol?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [GatewayLoadBalancerTunnelInterfaceArgs].
 */
@PulumiTagMarker
public class GatewayLoadBalancerTunnelInterfaceArgsBuilder internal constructor() {
    private var identifier: Output<Int>? = null

    private var port: Output<Int>? = null

    private var protocol: Output<Either<String, GatewayLoadBalancerTunnelProtocol>>? = null

    private var type: Output<Either<String, GatewayLoadBalancerTunnelInterfaceType>>? = null

    /**
     * @param value Identifier of gateway load balancer tunnel interface.
     */
    @JvmName("oclpahxkunypjkns")
    public suspend fun identifier(`value`: Output<Int>) {
        this.identifier = value
    }

    /**
     * @param value Port of gateway load balancer tunnel interface.
     */
    @JvmName("wrsbqebkrhymggnm")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value Protocol of gateway load balancer tunnel interface.
     */
    @JvmName("hqgcvgoritbuieyl")
    public suspend fun protocol(`value`: Output<Either<String, GatewayLoadBalancerTunnelProtocol>>) {
        this.protocol = value
    }

    /**
     * @param value Traffic type of gateway load balancer tunnel interface.
     */
    @JvmName("utwsrpwvkmhshigt")
    public suspend fun type(`value`: Output<Either<String, GatewayLoadBalancerTunnelInterfaceType>>) {
        this.type = value
    }

    /**
     * @param value Identifier of gateway load balancer tunnel interface.
     */
    @JvmName("bcedtpwlronesotd")
    public suspend fun identifier(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identifier = mapped
    }

    /**
     * @param value Port of gateway load balancer tunnel interface.
     */
    @JvmName("ykgadheabwlbbdrm")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value Protocol of gateway load balancer tunnel interface.
     */
    @JvmName("yjhcotntfgvrhxhf")
    public suspend fun protocol(`value`: Either<String, GatewayLoadBalancerTunnelProtocol>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Protocol of gateway load balancer tunnel interface.
     */
    @JvmName("pjpsynuioyyrmvjp")
    public fun protocol(`value`: String) {
        val toBeMapped = Either.ofLeft<String, GatewayLoadBalancerTunnelProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Protocol of gateway load balancer tunnel interface.
     */
    @JvmName("fisvwnvoklijijte")
    public fun protocol(`value`: GatewayLoadBalancerTunnelProtocol) {
        val toBeMapped = Either.ofRight<String, GatewayLoadBalancerTunnelProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Traffic type of gateway load balancer tunnel interface.
     */
    @JvmName("nkasjgasdssggyyl")
    public suspend fun type(`value`: Either<String, GatewayLoadBalancerTunnelInterfaceType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Traffic type of gateway load balancer tunnel interface.
     */
    @JvmName("fgmkvcmjbgejxwul")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, GatewayLoadBalancerTunnelInterfaceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Traffic type of gateway load balancer tunnel interface.
     */
    @JvmName("sxhvfnclksfislyh")
    public fun type(`value`: GatewayLoadBalancerTunnelInterfaceType) {
        val toBeMapped = Either.ofRight<String, GatewayLoadBalancerTunnelInterfaceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): GatewayLoadBalancerTunnelInterfaceArgs =
        GatewayLoadBalancerTunnelInterfaceArgs(
            identifier = identifier,
            port = port,
            protocol = protocol,
            type = type,
        )
}
