@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetApplicationGatewayBackendHealthOnDemandPlainArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.ApplicationGatewayProtocol
import com.pulumi.core.Either
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property applicationGatewayName The name of the application gateway.
 * @property backendAddressPool Reference to backend pool of application gateway to which probe request will be sent.
 * @property backendHttpSettings Reference to backend http setting of application gateway to be used for test probe.
 * @property expand Expands BackendAddressPool and BackendHttpSettings referenced in backend health.
 * @property host Host name to send the probe to.
 * @property match Criterion for classifying a healthy probe response.
 * @property path Relative path of probe. Valid path starts from '/'. Probe is sent to <Protocol>://<host>:<port><path>.
 * @property pickHostNameFromBackendHttpSettings Whether the host header should be picked from the backend http settings. Default value is false.
 * @property protocol The protocol used for the probe.
 * @property resourceGroupName The name of the resource group.
 * @property timeout The probe timeout in seconds. Probe marked as failed if valid response is not received with this timeout period. Acceptable values are from 1 second to 86400 seconds.
 */
public data class GetApplicationGatewayBackendHealthOnDemandPlainArgs(
    public val applicationGatewayName: String,
    public val backendAddressPool: SubResource? = null,
    public val backendHttpSettings: SubResource? = null,
    public val expand: String? = null,
    public val host: String? = null,
    public val match: ApplicationGatewayProbeHealthResponseMatch? = null,
    public val path: String? = null,
    public val pickHostNameFromBackendHttpSettings: Boolean? = null,
    public val protocol: Either<String, ApplicationGatewayProtocol>? = null,
    public val resourceGroupName: String,
    public val timeout: Int? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetApplicationGatewayBackendHealthOnDemandPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.GetApplicationGatewayBackendHealthOnDemandPlainArgs =
        com.pulumi.azurenative.network.inputs.GetApplicationGatewayBackendHealthOnDemandPlainArgs.builder()
            .applicationGatewayName(applicationGatewayName.let({ args0 -> args0 }))
            .backendAddressPool(backendAddressPool?.let({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .backendHttpSettings(backendHttpSettings?.let({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .expand(expand?.let({ args0 -> args0 }))
            .host(host?.let({ args0 -> args0 }))
            .match(match?.let({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .path(path?.let({ args0 -> args0 }))
            .pickHostNameFromBackendHttpSettings(pickHostNameFromBackendHttpSettings?.let({ args0 -> args0 }))
            .protocol(
                protocol?.let({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .timeout(timeout?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetApplicationGatewayBackendHealthOnDemandPlainArgs].
 */
@PulumiTagMarker
public class GetApplicationGatewayBackendHealthOnDemandPlainArgsBuilder internal constructor() {
    private var applicationGatewayName: String? = null

    private var backendAddressPool: SubResource? = null

    private var backendHttpSettings: SubResource? = null

    private var expand: String? = null

    private var host: String? = null

    private var match: ApplicationGatewayProbeHealthResponseMatch? = null

    private var path: String? = null

    private var pickHostNameFromBackendHttpSettings: Boolean? = null

    private var protocol: Either<String, ApplicationGatewayProtocol>? = null

    private var resourceGroupName: String? = null

    private var timeout: Int? = null

    /**
     * @param value The name of the application gateway.
     */
    @JvmName("qklqfhcdsklkmmmw")
    public suspend fun applicationGatewayName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.applicationGatewayName = mapped
    }

    /**
     * @param value Reference to backend pool of application gateway to which probe request will be sent.
     */
    @JvmName("lwyimitbejghgiog")
    public suspend fun backendAddressPool(`value`: SubResource?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.backendAddressPool = mapped
    }

    /**
     * @param argument Reference to backend pool of application gateway to which probe request will be sent.
     */
    @JvmName("prynqvfjgjvhgdwt")
    public suspend fun backendAddressPool(argument: suspend SubResourceBuilder.() -> Unit) {
        val toBeMapped = SubResourceBuilder().applySuspend { argument() }.build()
        val mapped = toBeMapped
        this.backendAddressPool = mapped
    }

    /**
     * @param value Reference to backend http setting of application gateway to be used for test probe.
     */
    @JvmName("qkskjmajvqmwimlj")
    public suspend fun backendHttpSettings(`value`: SubResource?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.backendHttpSettings = mapped
    }

    /**
     * @param argument Reference to backend http setting of application gateway to be used for test probe.
     */
    @JvmName("ycucfsbynchkldtb")
    public suspend fun backendHttpSettings(argument: suspend SubResourceBuilder.() -> Unit) {
        val toBeMapped = SubResourceBuilder().applySuspend { argument() }.build()
        val mapped = toBeMapped
        this.backendHttpSettings = mapped
    }

    /**
     * @param value Expands BackendAddressPool and BackendHttpSettings referenced in backend health.
     */
    @JvmName("nwhvtxotfcymkddy")
    public suspend fun expand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expand = mapped
    }

    /**
     * @param value Host name to send the probe to.
     */
    @JvmName("sqonmclfbrpckvcd")
    public suspend fun host(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.host = mapped
    }

    /**
     * @param value Criterion for classifying a healthy probe response.
     */
    @JvmName("jlljmrqhwdxhalyo")
    public suspend fun match(`value`: ApplicationGatewayProbeHealthResponseMatch?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.match = mapped
    }

    /**
     * @param argument Criterion for classifying a healthy probe response.
     */
    @JvmName("sdmedfcpaedhylgn")
    public suspend
    fun match(argument: suspend ApplicationGatewayProbeHealthResponseMatchBuilder.() -> Unit) {
        val toBeMapped = ApplicationGatewayProbeHealthResponseMatchBuilder().applySuspend {
            argument()
        }.build()
        val mapped = toBeMapped
        this.match = mapped
    }

    /**
     * @param value Relative path of probe. Valid path starts from '/'. Probe is sent to <Protocol>://<host>:<port><path>.
     */
    @JvmName("nosdvpndfhsiglix")
    public suspend fun path(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.path = mapped
    }

    /**
     * @param value Whether the host header should be picked from the backend http settings. Default value is false.
     */
    @JvmName("wydangnquyoyulsr")
    public suspend fun pickHostNameFromBackendHttpSettings(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pickHostNameFromBackendHttpSettings = mapped
    }

    /**
     * @param value The protocol used for the probe.
     */
    @JvmName("surigeiibmsnnmdx")
    public suspend fun protocol(`value`: Either<String, ApplicationGatewayProtocol>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.protocol = mapped
    }

    /**
     * @param value The protocol used for the probe.
     */
    @JvmName("ctyxdnrkfquqiscf")
    public fun protocol(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ApplicationGatewayProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.protocol = mapped
    }

    /**
     * @param value The protocol used for the probe.
     */
    @JvmName("qdprdwwpvmwjjtpn")
    public fun protocol(`value`: ApplicationGatewayProtocol) {
        val toBeMapped = Either.ofRight<String, ApplicationGatewayProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.protocol = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("mqciifshtvpcqgro")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The probe timeout in seconds. Probe marked as failed if valid response is not received with this timeout period. Acceptable values are from 1 second to 86400 seconds.
     */
    @JvmName("gkpwlxiduxiexaoh")
    public suspend fun timeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.timeout = mapped
    }

    internal fun build(): GetApplicationGatewayBackendHealthOnDemandPlainArgs =
        GetApplicationGatewayBackendHealthOnDemandPlainArgs(
            applicationGatewayName = applicationGatewayName ?: throw
                PulumiNullFieldException("applicationGatewayName"),
            backendAddressPool = backendAddressPool,
            backendHttpSettings = backendHttpSettings,
            expand = expand,
            host = host,
            match = match,
            path = path,
            pickHostNameFromBackendHttpSettings = pickHostNameFromBackendHttpSettings,
            protocol = protocol,
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            timeout = timeout,
        )
}
