@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetApplicationSecurityGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property applicationSecurityGroupName The name of the application security group.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetApplicationSecurityGroupPlainArgs(
    public val applicationSecurityGroupName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetApplicationSecurityGroupPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetApplicationSecurityGroupPlainArgs =
        com.pulumi.azurenative.network.inputs.GetApplicationSecurityGroupPlainArgs.builder()
            .applicationSecurityGroupName(applicationSecurityGroupName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetApplicationSecurityGroupPlainArgs].
 */
@PulumiTagMarker
public class GetApplicationSecurityGroupPlainArgsBuilder internal constructor() {
    private var applicationSecurityGroupName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the application security group.
     */
    @JvmName("jdpbiqxfdckblulj")
    public suspend fun applicationSecurityGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.applicationSecurityGroupName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("frqjnojuxwuavfph")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetApplicationSecurityGroupPlainArgs = GetApplicationSecurityGroupPlainArgs(
        applicationSecurityGroupName = applicationSecurityGroupName ?: throw
            PulumiNullFieldException("applicationSecurityGroupName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
