@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetConfigurationPolicyGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property configurationPolicyGroupName The name of the ConfigurationPolicyGroup being retrieved.
 * @property resourceGroupName The resource group name of the VpnServerConfiguration.
 * @property vpnServerConfigurationName The name of the VpnServerConfiguration.
 */
public data class GetConfigurationPolicyGroupPlainArgs(
    public val configurationPolicyGroupName: String,
    public val resourceGroupName: String,
    public val vpnServerConfigurationName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetConfigurationPolicyGroupPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetConfigurationPolicyGroupPlainArgs =
        com.pulumi.azurenative.network.inputs.GetConfigurationPolicyGroupPlainArgs.builder()
            .configurationPolicyGroupName(configurationPolicyGroupName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .vpnServerConfigurationName(vpnServerConfigurationName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetConfigurationPolicyGroupPlainArgs].
 */
@PulumiTagMarker
public class GetConfigurationPolicyGroupPlainArgsBuilder internal constructor() {
    private var configurationPolicyGroupName: String? = null

    private var resourceGroupName: String? = null

    private var vpnServerConfigurationName: String? = null

    /**
     * @param value The name of the ConfigurationPolicyGroup being retrieved.
     */
    @JvmName("jsvuewcwisofdsru")
    public suspend fun configurationPolicyGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.configurationPolicyGroupName = mapped
    }

    /**
     * @param value The resource group name of the VpnServerConfiguration.
     */
    @JvmName("srpcomlugjnpfjch")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the VpnServerConfiguration.
     */
    @JvmName("rhieybhhironfkng")
    public suspend fun vpnServerConfigurationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.vpnServerConfigurationName = mapped
    }

    internal fun build(): GetConfigurationPolicyGroupPlainArgs = GetConfigurationPolicyGroupPlainArgs(
        configurationPolicyGroupName = configurationPolicyGroupName ?: throw
            PulumiNullFieldException("configurationPolicyGroupName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        vpnServerConfigurationName = vpnServerConfigurationName ?: throw
            PulumiNullFieldException("vpnServerConfigurationName"),
    )
}
