@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetDefaultUserRulePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property configurationName The name of the network manager Security Configuration.
 * @property networkManagerName The name of the network manager.
 * @property resourceGroupName The name of the resource group.
 * @property ruleCollectionName The name of the network manager security Configuration rule collection.
 * @property ruleName The name of the rule.
 */
public data class GetDefaultUserRulePlainArgs(
    public val configurationName: String,
    public val networkManagerName: String,
    public val resourceGroupName: String,
    public val ruleCollectionName: String,
    public val ruleName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetDefaultUserRulePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetDefaultUserRulePlainArgs =
        com.pulumi.azurenative.network.inputs.GetDefaultUserRulePlainArgs.builder()
            .configurationName(configurationName.let({ args0 -> args0 }))
            .networkManagerName(networkManagerName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .ruleCollectionName(ruleCollectionName.let({ args0 -> args0 }))
            .ruleName(ruleName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDefaultUserRulePlainArgs].
 */
@PulumiTagMarker
public class GetDefaultUserRulePlainArgsBuilder internal constructor() {
    private var configurationName: String? = null

    private var networkManagerName: String? = null

    private var resourceGroupName: String? = null

    private var ruleCollectionName: String? = null

    private var ruleName: String? = null

    /**
     * @param value The name of the network manager Security Configuration.
     */
    @JvmName("ojpjimameqyyfmcc")
    public suspend fun configurationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.configurationName = mapped
    }

    /**
     * @param value The name of the network manager.
     */
    @JvmName("gublbydiiqoulppe")
    public suspend fun networkManagerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.networkManagerName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("qjdpemqhmejmsvtt")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the network manager security Configuration rule collection.
     */
    @JvmName("lbtnyyhtkwldqawv")
    public suspend fun ruleCollectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ruleCollectionName = mapped
    }

    /**
     * @param value The name of the rule.
     */
    @JvmName("rdvammyhhpvusomi")
    public suspend fun ruleName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ruleName = mapped
    }

    internal fun build(): GetDefaultUserRulePlainArgs = GetDefaultUserRulePlainArgs(
        configurationName = configurationName ?: throw PulumiNullFieldException("configurationName"),
        networkManagerName = networkManagerName ?: throw PulumiNullFieldException("networkManagerName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        ruleCollectionName = ruleCollectionName ?: throw PulumiNullFieldException("ruleCollectionName"),
        ruleName = ruleName ?: throw PulumiNullFieldException("ruleName"),
    )
}
