@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetExpressRouteConnectionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property connectionName The name of the ExpressRoute connection.
 * @property expressRouteGatewayName The name of the ExpressRoute gateway.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetExpressRouteConnectionPlainArgs(
    public val connectionName: String,
    public val expressRouteGatewayName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetExpressRouteConnectionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetExpressRouteConnectionPlainArgs =
        com.pulumi.azurenative.network.inputs.GetExpressRouteConnectionPlainArgs.builder()
            .connectionName(connectionName.let({ args0 -> args0 }))
            .expressRouteGatewayName(expressRouteGatewayName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetExpressRouteConnectionPlainArgs].
 */
@PulumiTagMarker
public class GetExpressRouteConnectionPlainArgsBuilder internal constructor() {
    private var connectionName: String? = null

    private var expressRouteGatewayName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the ExpressRoute connection.
     */
    @JvmName("fwkrijgjelhboxof")
    public suspend fun connectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.connectionName = mapped
    }

    /**
     * @param value The name of the ExpressRoute gateway.
     */
    @JvmName("jnfliqpkygwpywva")
    public suspend fun expressRouteGatewayName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.expressRouteGatewayName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("gtabvfndecvsfeme")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetExpressRouteConnectionPlainArgs = GetExpressRouteConnectionPlainArgs(
        connectionName = connectionName ?: throw PulumiNullFieldException("connectionName"),
        expressRouteGatewayName = expressRouteGatewayName ?: throw
            PulumiNullFieldException("expressRouteGatewayName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
