@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetFirewallPolicyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property expand Expands referenced resources.
 * @property firewallPolicyName The name of the Firewall Policy.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetFirewallPolicyPlainArgs(
    public val expand: String? = null,
    public val firewallPolicyName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetFirewallPolicyPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetFirewallPolicyPlainArgs =
        com.pulumi.azurenative.network.inputs.GetFirewallPolicyPlainArgs.builder()
            .expand(expand?.let({ args0 -> args0 }))
            .firewallPolicyName(firewallPolicyName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetFirewallPolicyPlainArgs].
 */
@PulumiTagMarker
public class GetFirewallPolicyPlainArgsBuilder internal constructor() {
    private var expand: String? = null

    private var firewallPolicyName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Expands referenced resources.
     */
    @JvmName("wrcpmgyuclmugbkh")
    public suspend fun expand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expand = mapped
    }

    /**
     * @param value The name of the Firewall Policy.
     */
    @JvmName("pjplloircsuwicce")
    public suspend fun firewallPolicyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.firewallPolicyName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("sixqdthlltqyntgg")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetFirewallPolicyPlainArgs = GetFirewallPolicyPlainArgs(
        expand = expand,
        firewallPolicyName = firewallPolicyName ?: throw PulumiNullFieldException("firewallPolicyName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
