@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetInboundEndpointPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dnsResolverName The name of the DNS resolver.
 * @property inboundEndpointName The name of the inbound endpoint for the DNS resolver.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetInboundEndpointPlainArgs(
    public val dnsResolverName: String,
    public val inboundEndpointName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetInboundEndpointPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetInboundEndpointPlainArgs =
        com.pulumi.azurenative.network.inputs.GetInboundEndpointPlainArgs.builder()
            .dnsResolverName(dnsResolverName.let({ args0 -> args0 }))
            .inboundEndpointName(inboundEndpointName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetInboundEndpointPlainArgs].
 */
@PulumiTagMarker
public class GetInboundEndpointPlainArgsBuilder internal constructor() {
    private var dnsResolverName: String? = null

    private var inboundEndpointName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the DNS resolver.
     */
    @JvmName("eaydamkplfndbalg")
    public suspend fun dnsResolverName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dnsResolverName = mapped
    }

    /**
     * @param value The name of the inbound endpoint for the DNS resolver.
     */
    @JvmName("iwwgobejdsmcynxv")
    public suspend fun inboundEndpointName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.inboundEndpointName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("bmqtmmpwpsnddesg")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetInboundEndpointPlainArgs = GetInboundEndpointPlainArgs(
        dnsResolverName = dnsResolverName ?: throw PulumiNullFieldException("dnsResolverName"),
        inboundEndpointName = inboundEndpointName ?: throw PulumiNullFieldException("inboundEndpointName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
